/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.arrays;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.arrays.TransactionalReferenceArray;

public class TransactionalReferenceArray_constructionTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test(expected=IllegalArgumentException.class)
    public void whenSizeNegative_thenNegativeArraySizeException() {
        new TransactionalReferenceArray(-1);
    }

    @Test
    public void whenConstructed() {
        long version = this.stm.getVersion();
        TransactionalReferenceArray array = new TransactionalReferenceArray(10);
        Assert.assertEquals((long)10L, (long)array.length());
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        for (int k = 0; k < 10; ++k) {
            Assert.assertNull((Object)array.atomicGet(k));
        }
    }
}

