/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.arrays;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.transactional.arrays.TransactionalReferenceArray;

public class TransactionalReferenceArray_copyToBiggerArrayTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
    }

    @Test
    public void whenNewCapacityTooSmall() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(10);
        long version = this.stm.getVersion();
        try {
            array.copyToBiggerArray(9);
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenArrayRemainsTheSame() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(3);
        array.set(0, (Object)"a");
        array.set(2, (Object)"c");
        long version = this.stm.getVersion();
        TransactionalReferenceArray newarray = array.copyToBiggerArray(3);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)3L, (long)newarray.length());
        Assert.assertEquals((Object)"[a, null, c]", (Object)newarray.toString());
    }

    @Test
    public void whenArrayGrows() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(3);
        array.set(0, (Object)"a");
        array.set(2, (Object)"c");
        long version = this.stm.getVersion();
        TransactionalReferenceArray newarray = array.copyToBiggerArray(5);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)5L, (long)newarray.length());
        Assert.assertEquals((Object)"[a, null, c, null, null]", (Object)newarray.toString());
    }
}

