/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.arrays;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.transactional.arrays.TransactionalReferenceArray;

public class TransactionalReferenceArray_getTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void whenIndexTooBig_thenIndexOutOfBoundsException() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(10);
        array.get(10);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void whenIndexTooSmall_thenIndexOutOfBoundsException() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(10);
        array.get(-1);
    }

    @Test
    public void whenNoTransactionAvailable() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(10);
        long version = this.stm.getVersion();
        String value = (String)array.get(5);
        Assert.assertNull((Object)value);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        String update = "bar";
        array.atomicSet(5, (Object)update);
        version = this.stm.getVersion();
        Assert.assertSame((Object)update, (Object)array.get(5));
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenTransactionActive() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(10);
        Transaction tx = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).build().start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)tx);
        String update = "bar";
        array.set(5, (Object)update);
        long version = this.stm.getVersion();
        String found = (String)array.get(5);
        Assert.assertSame((Object)update, (Object)found);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }
}

