/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.arrays;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.arrays.TransactionalReferenceArray;

public class TransactionalReferenceArray_setPerformanceTest {
    public final long transactionCount = 300000000L;
    public final int itemCount = 100000;
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void testTransactionalReferenceArray() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(100000);
        long version = this.stm.getVersion();
        long startNs = System.nanoTime();
        String value = "";
        for (long k = 0L; k < 300000000L; ++k) {
            array.set((int)k % 100000, (Object)value);
            if (k % 50000000L == 0L) {
                System.out.println("at: " + k);
            }
            if (k % 100000L != 0L) continue;
            value = value + " ";
        }
        long durationNs = System.nanoTime() - startNs;
        Assert.assertEquals((long)(version + 300000000L), (long)this.stm.getVersion());
        double transactionsPerSecond = 3.0E8 * (double)TimeUnit.SECONDS.toNanos(1L) / (double)durationNs;
        System.out.printf("Performance %s transactions/second\n", transactionsPerSecond);
    }

    @Test
    public void testTransactionalReferenceArrayUsingAtomicSet() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(100000);
        long version = this.stm.getVersion();
        long startNs = System.nanoTime();
        String value = "";
        for (long k = 0L; k < 300000000L; ++k) {
            array.atomicSet((int)k % 100000, (Object)value);
            if (k % 50000000L == 0L) {
                System.out.println("at: " + k);
            }
            if (k % 100000L != 0L) continue;
            value = value + " ";
        }
        long durationNs = System.nanoTime() - startNs;
        Assert.assertEquals((long)(version + 300000000L), (long)this.stm.getVersion());
        double transactionsPerSecond = 3.0E8 * (double)TimeUnit.SECONDS.toNanos(1L) / (double)durationNs;
        System.out.printf("Performance %s transactions/second\n", transactionsPerSecond);
    }

    @Test
    public void testAtomicReferenceArray() {
        AtomicReferenceArray<String> array = new AtomicReferenceArray<String>(100000);
        long startNs = System.nanoTime();
        String value = " ";
        for (long k = 0L; k < 300000000L; ++k) {
            array.set((int)k % 100000, value);
            if (k % 50000000L == 0L) {
                System.out.println("at: " + k);
            }
            if (k % 100000L != 0L) continue;
            value = value + " ";
        }
        long durationNs = System.nanoTime() - startNs;
        double transactionsPerSecond = 3.0E8 * (double)TimeUnit.SECONDS.toNanos(1L) / (double)durationNs;
        System.out.printf("Performance %s transactions/second\n", transactionsPerSecond);
    }
}

