/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import java.util.HashSet;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalArrayList;

public class TransactionalArrayList_addAll2Test {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenCollectionEmpty_thenReturnFalse() {
        TransactionalArrayList list = new TransactionalArrayList((Object[])new String[]{"a", "b"});
        long version = this.stm.getVersion();
        boolean changed = list.addAll(0, new HashSet());
        Assert.assertFalse((boolean)changed);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"[a, b]", (Object)list.toString());
    }

    @Test
    public void whenCollectionNull_thenNullPointerException() {
        TransactionalArrayList list = new TransactionalArrayList();
        long version = this.stm.getVersion();
        try {
            list.addAll(0, null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenIndexTooSmall_thenIndexOutOfBoundsException() {
        TransactionalArrayList list = new TransactionalArrayList();
        long version = this.stm.getVersion();
        try {
            list.addAll(-1, new HashSet());
            Assert.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenIndexTooBig_thenIndexOutOfBoundsException() {
        TransactionalArrayList list = new TransactionalArrayList((Object[])new String[]{"a", "b"});
        long version = this.stm.getVersion();
        try {
            list.addAll(3, new HashSet());
            Assert.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    @Ignore
    public void whenAddedInFront() {
        TransactionalArrayList list = new TransactionalArrayList((Object[])new String[]{"c", "d"});
        LinkedList<String> items = new LinkedList<String>();
        items.add("a");
        items.add("b");
        list.addAll(0, items);
        Assert.assertEquals((Object)"[a, b, c, d]", (Object)list.toString());
    }

    @Test
    @Ignore
    public void whenAddedToEnd() {
    }

    @Test
    @Ignore
    public void whenAddedInBetween() {
    }
}

