/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import java.util.HashSet;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalArrayList;

public class TransactionalArrayList_equalsTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenObjectNull_thenFalse() {
        TransactionalArrayList list = new TransactionalArrayList();
        long version = this.stm.getVersion();
        boolean result = list.equals(null);
        Assert.assertFalse((boolean)result);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenObjectSame_thenTrue() {
        TransactionalArrayList list = new TransactionalArrayList();
        long version = this.stm.getVersion();
        boolean result = list.equals((Object)list);
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenNotList_thenFalse() {
        TransactionalArrayList list = new TransactionalArrayList();
        long version = this.stm.getVersion();
        boolean result = list.equals(new HashSet());
        Assert.assertFalse((boolean)result);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenSizeDiffers_thenFalse() {
        TransactionalArrayList list = new TransactionalArrayList();
        list.add((Object)"foo");
        LinkedList<String> that = new LinkedList<String>();
        that.add("foo");
        that.add("bar");
        long version = this.stm.getVersion();
        boolean result = list.equals(that);
        Assert.assertFalse((boolean)result);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenContentSame() {
        TransactionalArrayList list = new TransactionalArrayList();
        list.add((Object)"1");
        list.add((Object)"2");
        list.add((Object)"3");
        LinkedList<String> that = new LinkedList<String>();
        that.add("1");
        that.add("2");
        that.add("3");
        long version = this.stm.getVersion();
        boolean result = list.equals(that);
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenContentSameButOrderDifferent() {
        TransactionalArrayList list = new TransactionalArrayList();
        list.add((Object)"1");
        list.add((Object)"2");
        list.add((Object)"3");
        LinkedList<String> that = new LinkedList<String>();
        that.add("2");
        that.add("3");
        that.add("1");
        long version = this.stm.getVersion();
        boolean result = list.equals(that);
        Assert.assertFalse((boolean)result);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenContentDiffers() {
        TransactionalArrayList list = new TransactionalArrayList();
        list.add((Object)"1");
        list.add((Object)"2");
        list.add((Object)"3");
        LinkedList<String> that = new LinkedList<String>();
        that.add("1");
        that.add("2");
        that.add("4");
        long version = this.stm.getVersion();
        boolean result = list.equals(that);
        Assert.assertFalse((boolean)result);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }
}

