/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalArrayList;

public class TransactionalArrayList_getPerformanceTest {
    public final long transactionCount = 100000000L;
    public final int itemCount = 1000;
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test() {
        TransactionalArrayList list = new TransactionalArrayList();
        for (int k = 0; k < 1000; ++k) {
            list.add((Object)("" + k));
        }
        long version = this.stm.getVersion();
        long startNs = System.nanoTime();
        for (long k = 0L; k < 100000000L; ++k) {
            list.get((int)(k % 1000L));
            if (k % 10000000L != 0L) continue;
            System.out.println("at: " + k);
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        long durationNs = System.nanoTime() - startNs;
        double transactionsPerSecond = 1.0E8 * (double)TimeUnit.SECONDS.toNanos(1L) / (double)durationNs;
        System.out.printf("Performance %s transactions/second\n", TestUtils.format((double)transactionsPerSecond));
    }
}

