/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import java.util.HashSet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalArrayList;

public class TransactionalArrayList_removeAllTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenCollectionNull_thenNullPointerException() {
        TransactionalArrayList list = new TransactionalArrayList();
        long version = this.stm.getVersion();
        try {
            list.removeAll(null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenCollectionEmpty() {
        TransactionalArrayList list = new TransactionalArrayList();
        long version = this.stm.getVersion();
        boolean changed = list.removeAll(new HashSet());
        Assert.assertFalse((boolean)changed);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenNoMatchingElements() {
        TransactionalArrayList list = new TransactionalArrayList((Object[])new String[]{"a", "b", "c"});
        HashSet<String> items = new HashSet<String>();
        items.add("d");
        items.add("e");
        long version = this.stm.getVersion();
        boolean changed = list.removeAll(items);
        Assert.assertFalse((boolean)changed);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenMatchingElements() {
        TransactionalArrayList list = new TransactionalArrayList((Object[])new String[]{"a", "b", "c", "d", "e"});
        HashSet<String> items = new HashSet<String>();
        items.add("a");
        items.add("c");
        items.add("e");
        long version = this.stm.getVersion();
        boolean changed = list.removeAll(items);
        Assert.assertTrue((boolean)changed);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"[b, d]", (Object)list.toString());
    }

    @Test
    public void whenElementMatchingMultipleTimes() {
        TransactionalArrayList list = new TransactionalArrayList((Object[])new String[]{"a", "b", "a", "d", "e"});
        HashSet<String> items = new HashSet<String>();
        items.add("a");
        long version = this.stm.getVersion();
        boolean changed = list.removeAll(items);
        Assert.assertTrue((boolean)changed);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)"[b, d, e]", (Object)list.toString());
    }
}

