/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalArrayList;

public class TransactionalArrayList_removeIndexTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenIndexTooSmall_thenIndexOutOfBoundsException() {
        TransactionalArrayList list = new TransactionalArrayList();
        long version = this.stm.getVersion();
        try {
            list.remove(-1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenIndexTooBig_thenIndexOutOfBoundsException() {
        TransactionalArrayList list = new TransactionalArrayList();
        list.add((Object)"a");
        list.add((Object)"b");
        long version = this.stm.getVersion();
        try {
            list.remove(2);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenIndexVeryMuchTooBig_thenIndexOutOfBoundsException() {
        TransactionalArrayList list = new TransactionalArrayList();
        list.add((Object)"a");
        list.add((Object)"b");
        long version = this.stm.getVersion();
        try {
            list.remove(20);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenFirstItemRemoved() {
        TransactionalArrayList list = new TransactionalArrayList((Object[])new String[]{"a", "b", "c", "d", "e"});
        long version = this.stm.getVersion();
        String found = (String)list.remove(0);
        Assert.assertEquals((Object)"a", (Object)found);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((Object)"[b, c, d, e]", (Object)list.toString());
    }

    @Test
    public void whenMiddleItemRemoved() {
        TransactionalArrayList list = new TransactionalArrayList((Object[])new String[]{"a", "b", "c"});
        long version = this.stm.getVersion();
        String found = (String)list.remove(1);
        Assert.assertEquals((Object)"b", (Object)found);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"[a, c]", (Object)list.toString());
    }

    @Test
    public void whenLastItemRemoved() {
        TransactionalArrayList list = new TransactionalArrayList((Object[])new String[]{"a", "b", "c"});
        long version = this.stm.getVersion();
        String found = (String)list.remove(2);
        Assert.assertEquals((Object)"c", (Object)found);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"[a, b]", (Object)list.toString());
    }
}

