/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import java.util.HashSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalArrayList;

public class TransactionalArrayList_retainAllTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenCollectionNull_thenNullPointerException() {
        TransactionalArrayList list = new TransactionalArrayList((Object[])new String[]{"a", "b", "c"});
        long version = this.stm.getVersion();
        try {
            list.retainAll(null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[a, b, c]", (Object)list.toString());
    }

    @Test
    public void whenMatchingItems_othersRemoved() {
        TransactionalArrayList list = new TransactionalArrayList((Object[])new String[]{"a", "b", "c", "e", "a"});
        long version = this.stm.getVersion();
        HashSet<String> set = new HashSet<String>();
        set.add("a");
        set.add("e");
        boolean changed = list.retainAll(set);
        Assert.assertTrue((boolean)changed);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[a, e, a]", (Object)list.toString());
    }

    @Test
    public void whenCollectionEmpty_thenEverythingRemoved() {
        TransactionalArrayList list = new TransactionalArrayList((Object[])new String[]{"a", "b", "c"});
        long version = this.stm.getVersion();
        boolean changed = list.retainAll(new HashSet());
        Assert.assertTrue((boolean)changed);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[]", (Object)list.toString());
    }

    @Test
    public void whenNothingMatches_thenEverythingRemoved() {
        TransactionalArrayList list = new TransactionalArrayList((Object[])new String[]{"a", "b", "c"});
        long version = this.stm.getVersion();
        HashSet<String> strings = new HashSet<String>();
        strings.add("x");
        strings.add("y");
        boolean changed = list.retainAll(strings);
        Assert.assertTrue((boolean)changed);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[]", (Object)list.toString());
    }

    @Test
    public void whenEverythingMatches_thenNoChange() {
        TransactionalArrayList list = new TransactionalArrayList((Object[])new String[]{"a", "b", "c", "b", "b", "a"});
        long version = this.stm.getVersion();
        HashSet<String> strings = new HashSet<String>();
        strings.add("a");
        strings.add("b");
        strings.add("c");
        boolean changed = list.retainAll(strings);
        Assert.assertFalse((boolean)changed);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[a, b, c, b, b, a]", (Object)list.toString());
    }
}

