/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalArrayList;

public class TransactionalArrayList_toArray1Test {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenArrayIsBigger_thenItemsFollowingAreCleared() {
        TransactionalArrayList list = new TransactionalArrayList((Object[])new String[]{"a", "b", "c"});
        Object[] in = new String[]{"1", "2", "3", "4", "5"};
        String[] out = (String[])list.toArray(in);
        Assert.assertSame((Object)in, (Object)out);
        Assert.assertEquals((Object)"a", (Object)out[0]);
        Assert.assertEquals((Object)"b", (Object)out[1]);
        Assert.assertEquals((Object)"c", (Object)out[2]);
        Assert.assertNull((Object)out[3]);
        Assert.assertNull((Object)out[4]);
    }

    @Test
    public void whenArrayNull_thenNullPointerException() {
        TransactionalArrayList list = new TransactionalArrayList();
        long version = this.stm.getVersion();
        try {
            list.toArray((Object[])null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenArrayBigEnough() {
        TransactionalArrayList list = new TransactionalArrayList((Object[])new String[]{"a", "b", "c"});
        Object[] in = new String[3];
        String[] out = (String[])list.toArray(in);
        Assert.assertSame((Object)in, (Object)out);
        Assert.assertEquals((Object)"a", (Object)out[0]);
        Assert.assertEquals((Object)"b", (Object)out[1]);
        Assert.assertEquals((Object)"c", (Object)out[2]);
    }

    @Test
    public void whenArrayNotBigEnough() {
        Object[] in = new String[2];
        TransactionalArrayList list = new TransactionalArrayList((Object[])new String[]{"a", "b", "c"});
        String[] out = (String[])list.toArray(in);
        Assert.assertFalse((in == out ? 1 : 0) != 0);
        Assert.assertEquals((long)3L, (long)out.length);
        Assert.assertEquals((Object)"a", (Object)out[0]);
        Assert.assertEquals((Object)"b", (Object)out[1]);
        Assert.assertEquals((Object)"c", (Object)out[2]);
    }
}

