/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalLinkedList;

public class TransactionalLinkedList_ConnectionPoolRegressionStressTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void concurrentPutsFirst() {
        this.concurrentPuts(true);
    }

    @Test
    public void concurrentPutLast() {
        this.concurrentPuts(false);
    }

    public void concurrentPuts(boolean first) {
        TransactionalLinkedList list = new TransactionalLinkedList();
        int produceCount = 400000;
        int threadCount = 2;
        TestThread[] threads = new PutFirstThread[threadCount];
        for (int k = 0; k < threads.length; ++k) {
            threads[k] = new PutFirstThread(k, produceCount, (TransactionalLinkedList<String>)list, first);
        }
        TestUtils.startAll((TestThread[])threads);
        TestUtils.joinAll((TestThread[])threads);
        HashSet<String> expected = new HashSet<String>();
        for (TestThread thread : threads) {
            expected.addAll(thread.producedList);
        }
        HashSet found = new HashSet();
        found.addAll(list);
        Assert.assertEquals(expected, found);
    }

    @Test
    public void realisticInterleavingPutsAndTakes() throws InterruptedException {
        TransactionalLinkedList list = new TransactionalLinkedList();
        long version = this.stm.getVersion();
        HashSet<String> producedItems = new HashSet<String>();
        HashSet<String> consumedItems = new HashSet<String>();
        for (int k = 0; k < 1000; ++k) {
            if (TestUtils.randomBoolean()) {
                String item = (String)list.poll();
                if (item == null) continue;
                consumedItems.add(item);
                continue;
            }
            String newItem = String.valueOf(producedItems.size());
            producedItems.add(newItem);
            list.putLast(newItem);
        }
        int diff = producedItems.size() - consumedItems.size();
        for (int k = 0; k < diff; ++k) {
            String item = (String)list.takeFirst();
            consumedItems.add(item);
        }
        Assert.assertEquals((long)(version + (long)(producedItems.size() * 2)), (long)this.stm.getVersion());
        Assert.assertEquals(producedItems, consumedItems);
        Assert.assertEquals((Object)"[]", (Object)list.toString());
    }

    @Test
    public void interleavingPutAndTakes() throws InterruptedException {
        TransactionalLinkedList list = new TransactionalLinkedList();
        long version = this.stm.getVersion();
        String item1 = "1";
        String item2 = "2";
        String item3 = "3";
        String item4 = "4";
        list.putLast(item1);
        Assert.assertSame((Object)item1, list.takeFirst());
        list.putLast(item2);
        Assert.assertSame((Object)item2, list.takeFirst());
        list.putLast(item3);
        list.putLast(item4);
        Assert.assertSame((Object)item3, list.takeFirst());
        Assert.assertSame((Object)item4, list.takeFirst());
        Assert.assertEquals((long)(version + 8L), (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[]", (Object)list.toString());
    }

    @Test
    public void nonInterleavingPutsAndTakes() throws InterruptedException {
        TransactionalLinkedList list = new TransactionalLinkedList();
        long version = this.stm.getVersion();
        String item1 = "1";
        String item2 = "2";
        String item3 = "3";
        String item4 = "4";
        list.putLast(item1);
        list.putLast(item2);
        list.putLast(item3);
        list.putLast(item4);
        Assert.assertSame((Object)item1, list.takeFirst());
        Assert.assertSame((Object)item2, list.takeFirst());
        Assert.assertSame((Object)item3, list.takeFirst());
        Assert.assertSame((Object)item4, list.takeFirst());
        Assert.assertEquals((long)(version + 8L), (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[]", (Object)list.toString());
    }

    public class PutFirstThread
    extends TestThread {
        final int produceCount;
        final TransactionalLinkedList<String> list;
        final List<String> producedList;
        final boolean first;

        public PutFirstThread(int id, int produceCount, TransactionalLinkedList<String> list, boolean first) {
            super("PutFirstThread-" + id);
            this.producedList = new LinkedList<String>();
            this.produceCount = produceCount;
            this.list = list;
            this.first = first;
        }

        public void doRun() throws Exception {
            for (int k = 0; k < this.produceCount; ++k) {
                String item = String.valueOf(System.nanoTime());
                if (k % 10000 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), k);
                }
                if (this.first) {
                    this.list.putFirst((Object)item);
                } else {
                    this.list.putLast((Object)item);
                }
                this.producedList.add(item);
            }
        }
    }
}

