/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.transactional.collections.TransactionalLinkedList;

public class TransactionalLinkedList_MiscellaneousTest {
    private Stm stm;
    private TransactionFactory updateTxFactory;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        this.updateTxFactory = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setReadonly(false).build();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void rollbackPuts() throws InterruptedException {
        TransactionalLinkedList list = new TransactionalLinkedList();
        list.put((Object)"1");
        long version = this.stm.getVersion();
        Transaction t = this.updateTxFactory.start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)t);
        list.put((Object)"2");
        list.put((Object)"3");
        t.abort();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[1]", (Object)list.toString());
    }

    @Test
    public void rollbackTakes() throws InterruptedException {
        TransactionalLinkedList list = new TransactionalLinkedList();
        list.put((Object)"1");
        list.put((Object)"2");
        list.put((Object)"3");
        long version = this.stm.getVersion();
        Transaction t = this.updateTxFactory.start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)t);
        list.take();
        list.take();
        t.abort();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[1, 2, 3]", (Object)list.toString());
    }

    @Test
    public void testToString() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        Assert.assertEquals((Object)"[]", (Object)list.toString());
        list.add((Object)"1");
        Assert.assertEquals((Object)"[1]", (Object)list.toString());
        list.add((Object)"2");
        list.add((Object)"3");
        Assert.assertEquals((Object)"[1, 2, 3]", (Object)list.toString());
    }
}

