/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalLinkedList;

public class TransactionalLinkedList_PerformanceTest {
    private Stm stm;
    private int iterations = 10;
    private int count = 1000000;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void testRelaxedTransactionalLinkedList() {
        TransactionalLinkedList list = new TransactionalLinkedList(10000000, true);
        long startNs = System.nanoTime();
        for (int l = 0; l < this.iterations; ++l) {
            for (int k = 0; k < this.count; ++k) {
                list.add((Object)k);
            }
            list.clear();
            System.out.println("completed iteration " + l);
        }
        long durationNs = System.nanoTime() - startNs;
        double transactionsPerSecond = 1.0 * (double)this.count * (double)this.iterations * (double)TimeUnit.SECONDS.toNanos(1L) / (double)durationNs;
        System.out.printf("Performance %s transactions/second\n", TestUtils.format((double)transactionsPerSecond));
    }

    @Test
    public void testStrictTransactionalLinkedList() {
        TransactionalLinkedList list = new TransactionalLinkedList(10000000, false);
        long startNs = System.nanoTime();
        for (int l = 0; l < this.iterations; ++l) {
            for (int k = 0; k < this.count; ++k) {
                list.add((Object)k);
            }
            list.clear();
            System.out.println("completed iteration " + l);
        }
        long durationNs = System.nanoTime() - startNs;
        double transactionsPerSecond = 1.0 * (double)this.count * (double)this.iterations * (double)TimeUnit.SECONDS.toNanos(1L) / (double)durationNs;
        System.out.printf("Performance %s transactions/second\n", TestUtils.format((double)transactionsPerSecond));
    }

    @Test
    public void testLinkedBlockingQueue() {
        LinkedBlockingQueue<Integer> list = new LinkedBlockingQueue<Integer>();
        long startNs = System.nanoTime();
        for (int l = 0; l < this.iterations; ++l) {
            for (int k = 0; k < this.count; ++k) {
                list.add(k);
            }
            list.clear();
            System.out.println("completed iteration " + l);
        }
        long durationNs = System.nanoTime() - startNs;
        double transactionsPerSecond = 1.0 * (double)this.count * (double)this.iterations * (double)TimeUnit.SECONDS.toNanos(1L) / (double)durationNs;
        System.out.printf("Performance %s transactions/second\n", TestUtils.format((double)transactionsPerSecond));
    }
}

