/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import java.util.concurrent.atomic.AtomicLong;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalLinkedList;

public class TransactionalLinkedList_TakeFirstPutLastStressTest {
    private int takeFirstThreadCount = 2;
    private int putLastThreadCount = 2;
    private int dequeCapacity;
    private int produceCount = 1000000;
    private AtomicLong itemGenerator;
    private AtomicLong takeCounter;
    private TransactionalLinkedList<Long> list;
    private PutLastThread[] putLastThreads;
    private TakeFirstThread[] takeFirstThreads;

    @Before
    public void setUp() {
        int k;
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.itemGenerator = new AtomicLong();
        this.takeCounter = new AtomicLong(this.putLastThreadCount * this.produceCount);
        this.putLastThreads = new PutLastThread[this.putLastThreadCount];
        for (k = 0; k < this.putLastThreadCount; ++k) {
            this.putLastThreads[k] = new PutLastThread(k);
        }
        this.takeFirstThreads = new TakeFirstThread[this.takeFirstThreadCount];
        for (k = 0; k < this.takeFirstThreadCount; ++k) {
            this.takeFirstThreads[k] = new TakeFirstThread(k);
        }
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void runWithCapacity() {
        this.dequeCapacity = 10;
        this.list = new TransactionalLinkedList(this.dequeCapacity);
        TestUtils.startAll((TestThread[])this.putLastThreads);
        TestUtils.startAll((TestThread[])this.takeFirstThreads);
        TestUtils.joinAll((TestThread[])this.putLastThreads);
        TestUtils.joinAll((TestThread[])this.takeFirstThreads);
    }

    @Test
    public void runWithoutCapacity() {
        this.dequeCapacity = Integer.MAX_VALUE;
        this.list = new TransactionalLinkedList(this.dequeCapacity);
        TestUtils.startAll((TestThread[])this.putLastThreads);
        TestUtils.startAll((TestThread[])this.takeFirstThreads);
        TestUtils.joinAll((TestThread[])this.putLastThreads);
        TestUtils.joinAll((TestThread[])this.takeFirstThreads);
    }

    public class PutLastThread
    extends TestThread {
        public PutLastThread(int id) {
            super("PutLastThread-" + id);
        }

        public void doRun() throws Exception {
            for (int k = 0; k < TransactionalLinkedList_TakeFirstPutLastStressTest.this.produceCount; ++k) {
                TransactionalLinkedList_TakeFirstPutLastStressTest.this.list.putLast((Object)TransactionalLinkedList_TakeFirstPutLastStressTest.this.itemGenerator.incrementAndGet());
                if (k % 100000 != 0) continue;
                System.out.printf("%s is at %s\n", this.getName(), k);
            }
        }
    }

    public class TakeFirstThread
    extends TestThread {
        public TakeFirstThread(int id) {
            super("TakeFirstThread-" + id);
        }

        public void doRun() throws Exception {
            int k = 0;
            while (TransactionalLinkedList_TakeFirstPutLastStressTest.this.takeCounter.decrementAndGet() > 0L) {
                Long l = (Long)TransactionalLinkedList_TakeFirstPutLastStressTest.this.list.takeFirst();
                if (l == null) {
                    throw new NullPointerException();
                }
                if (k % 100000 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), k);
                }
                ++k;
            }
        }
    }
}

