/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalLinkedList;

public class TransactionalLinkedList_addLastTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
    }

    @Test
    public void addLastWithNullFails() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        long version = this.stm.getVersion();
        try {
            list.addLast(null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)list.size());
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void addLastOnEmptyDeque() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        long version = this.stm.getVersion();
        list.addLast((Object)"1");
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[1]", (Object)list.toString());
    }

    @Test
    public void addLastOnNonEmptyDeque() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        list.addLast((Object)"1");
        long version = this.stm.getVersion();
        list.addLast((Object)"2");
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[1, 2]", (Object)list.toString());
    }

    @Test
    public void addLastOnFullDeque() {
        TransactionalLinkedList list = new TransactionalLinkedList(1);
        list.add((Object)"1");
        long version = this.stm.getVersion();
        try {
            list.addLast((Object)"2");
            Assert.fail();
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[1]", (Object)list.toString());
        Assert.assertEquals((long)1L, (long)list.size());
    }
}

