/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalLinkedList;

public class TransactionalLinkedList_addTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
    }

    @Test
    public void addWithNullFails() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        long version = this.stm.getVersion();
        try {
            list.add(null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)list.size());
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void addOnEmptyDeque() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        long version = this.stm.getVersion();
        System.out.println("------------------------------------------");
        boolean result = list.add((Object)"1");
        System.out.println("------------------------------------------");
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[1]", (Object)list.toString());
    }

    @Test
    public void addOnNonEmptyDeque() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        list.add((Object)"1");
        long version = this.stm.getVersion();
        boolean result = list.add((Object)"2");
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[1, 2]", (Object)list.toString());
    }

    @Test
    public void addOnFullDeque() {
        TransactionalLinkedList list = new TransactionalLinkedList(1);
        list.add((Object)"1");
        long version = this.stm.getVersion();
        try {
            list.add((Object)"2");
            Assert.fail();
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[1]", (Object)list.toString());
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void addVeryMany() {
        int k;
        TransactionalLinkedList list = new TransactionalLinkedList();
        int count = 10000;
        for (k = 0; k < count; ++k) {
            list.add((Object)("" + k));
        }
        Assert.assertEquals((long)list.size(), (long)count);
        for (k = 0; k < count; ++k) {
            Assert.assertEquals((Object)("" + k), (Object)list.get(k));
        }
    }
}

