/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalLinkedList;

public class TransactionalLinkedList_clearTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
    }

    @Test
    public void clearEmptyDeque() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        long version = this.stm.getVersion();
        list.clear();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertTrue((boolean)list.isEmpty());
        Assert.assertEquals((Object)"[]", (Object)list.toString());
    }

    @Test
    public void clearNonEmptyDeque() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        list.add((Object)"1");
        list.add((Object)"2");
        list.add((Object)"3");
        long version = this.stm.getVersion();
        list.clear();
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertTrue((boolean)list.isEmpty());
        Assert.assertEquals((Object)"[]", (Object)list.toString());
    }
}

