/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.api.exceptions.OptimisticLockFailedWriteConflict;
import org.multiverse.transactional.collections.TransactionalLinkedList;

public class TransactionalLinkedList_commutingTest {
    private Stm stm;
    private TransactionFactory txFactory;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        this.txFactory = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setReadTrackingEnabled(true).setReadonly(false).build();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test() {
        TransactionalLinkedList list = new TransactionalLinkedList(10000, true);
        list.add((Object)"2");
        list.add((Object)"3");
        list.add((Object)"4");
        Transaction tx1 = this.txFactory.start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)tx1);
        list.addFirst((Object)"1");
        Transaction tx2 = this.txFactory.start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)tx2);
        list.addLast((Object)"5");
        tx1.commit();
        tx2.commit();
        Assert.assertEquals((long)5L, (long)list.size());
        Assert.assertEquals((Object)"[1, 2, 3, 4, 5]", (Object)list.toString());
    }

    @Test
    public void testNonCommuting() {
        TransactionalLinkedList list = new TransactionalLinkedList((Object[])new String[]{"2", "3", "4"});
        Transaction tx1 = this.txFactory.start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)tx1);
        list.addFirst((Object)"1");
        list.size();
        Transaction tx2 = this.txFactory.start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)tx2);
        list.addLast((Object)"5");
        list.size();
        tx1.commit();
        try {
            tx2.commit();
            Assert.fail();
        }
        catch (OptimisticLockFailedWriteConflict expected) {
            // empty catch block
        }
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((Object)"[1, 2, 3, 4]", (Object)list.toString());
    }
}

