/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalLinkedList;

public class TransactionalLinkedList_descendingIteratorTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
    }

    @Test(expected=NoSuchElementException.class)
    public void emptyList() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        Iterator it = list.descendingIterator();
        Assert.assertFalse((boolean)it.hasNext());
        it.next();
    }

    @Test
    public void nonEmptyList() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        list.add((Object)"1");
        list.add((Object)"2");
        Iterator it = list.descendingIterator();
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals((Object)"2", it.next());
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals((Object)"1", it.next());
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void remove() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        list.add((Object)"1");
        list.add((Object)"2");
        Iterator it = list.descendingIterator();
        it.next();
        long version = this.stm.getVersion();
        it.remove();
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[1]", (Object)list.toString());
    }

    @Test(expected=NoSuchElementException.class)
    public void removeWithoutNextCalled() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        list.add((Object)"1");
        Iterator it = list.descendingIterator();
        it.remove();
    }
}

