/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalLinkedList;

public class TransactionalLinkedList_getTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
    }

    @Test
    public void getTooSmallIndex() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        long version = this.stm.getVersion();
        try {
            list.get(-1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[]", (Object)list.toString());
    }

    @Test
    public void getTooLargeIndex() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        list.add((Object)"1");
        long version = this.stm.getVersion();
        try {
            list.get(1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[1]", (Object)list.toString());
    }

    @Test
    public void get() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        list.add((Object)"1");
        list.add((Object)"2");
        list.add((Object)"3");
        long version = this.stm.getVersion();
        Assert.assertEquals((Object)"1", (Object)list.get(0));
        Assert.assertEquals((Object)"2", (Object)list.get(1));
        Assert.assertEquals((Object)"3", (Object)list.get(2));
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[1, 2, 3]", (Object)list.toString());
    }
}

