/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalLinkedList;

public class TransactionalLinkedList_indexOfTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
    }

    @Test
    public void indexOfNullFails() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        long version = this.stm.getVersion();
        try {
            list.indexOf(null);
            Assert.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[]", (Object)list.toString());
    }

    @Test
    public void indexOf() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        list.add((Object)"1");
        list.add((Object)"2");
        list.add((Object)"3");
        list.add((Object)"1");
        long version = this.stm.getVersion();
        Assert.assertEquals((long)0L, (long)list.indexOf((Object)"1"));
        Assert.assertEquals((long)1L, (long)list.indexOf((Object)"2"));
        Assert.assertEquals((long)2L, (long)list.indexOf((Object)"3"));
        Assert.assertEquals((long)-1L, (long)list.indexOf((Object)"a"));
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[1, 2, 3, 1]", (Object)list.toString());
    }
}

