/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalLinkedList;

public class TransactionalLinkedList_pollTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
    }

    @Test
    public void whenSutIsEmptyNullIsReturned() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        long version = this.stm.getVersion();
        String result = (String)list.poll();
        Assert.assertNull((Object)result);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)0L, (long)list.size());
        Assert.assertEquals((Object)"[]", (Object)list.toString());
    }

    @Test
    public void whenSutIsSingletonSetBecomesEmpty() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        list.add((Object)"1");
        long version = this.stm.getVersion();
        String result = (String)list.poll();
        Assert.assertEquals((Object)"1", (Object)result);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)0L, (long)list.size());
        Assert.assertEquals((Object)"[]", (Object)list.toString());
    }

    @Test
    public void whenSutContainsMultipleItemsFirstIsRemoved() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        list.add((Object)"1");
        list.add((Object)"2");
        long version = this.stm.getVersion();
        String result = (String)list.poll();
        Assert.assertEquals((Object)"1", (Object)result);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"[2]", (Object)list.toString());
    }
}

