/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.api.exceptions.Retry;
import org.multiverse.transactional.collections.TransactionalLinkedList;

public class TransactionalLinkedList_putFirstTest {
    private Stm stm;
    private TransactionFactory updateTxFactory;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        this.updateTxFactory = this.stm.getTransactionFactoryBuilder().build();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenNullItemNullPointerException() throws InterruptedException {
        TransactionalLinkedList list = new TransactionalLinkedList();
        long version = this.stm.getVersion();
        try {
            list.putFirst(null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[]", (Object)list.toString());
    }

    @Test
    public void whenListIsEmptyItemBecomesTheSingleContent() throws InterruptedException {
        TransactionalLinkedList list = new TransactionalLinkedList();
        long version = this.stm.getVersion();
        list.putFirst((Object)"1");
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[1]", (Object)list.toString());
    }

    @Test
    public void whenListIsNonEmptyItemIsAddedToFront() throws InterruptedException {
        TransactionalLinkedList list = new TransactionalLinkedList();
        list.add((Object)"1");
        long version = this.stm.getVersion();
        list.putFirst((Object)"2");
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[2, 1]", (Object)list.toString());
    }

    @Test
    public void whenListIsFullRetryErrorIsThrown() throws InterruptedException {
        TransactionalLinkedList list = new TransactionalLinkedList(2);
        list.put((Object)"1");
        list.put((Object)"2");
        long version = this.stm.getVersion();
        Transaction t = this.updateTxFactory.start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)t);
        try {
            list.putFirst((Object)"3");
            Assert.fail();
        }
        catch (Retry expected) {
            // empty catch block
        }
        t.abort();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[1, 2]", (Object)list.toString());
    }
}

