/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalLinkedList;

public class TransactionalLinkedList_removeObjectTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
    }

    @Test
    public void remove_notFound() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        list.add((Object)"1");
        list.add((Object)"2");
        long version = this.stm.getVersion();
        boolean result = list.remove((Object)"3");
        Assert.assertFalse((boolean)result);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"[1, 2]", (Object)list.toString());
    }

    @Test
    public void remove_fromEmptyList() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        long version = this.stm.getVersion();
        boolean result = list.remove((Object)"1");
        Assert.assertFalse((boolean)result);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)0L, (long)list.size());
        Assert.assertEquals((Object)"[]", (Object)list.toString());
    }

    @Test
    public void remove_fromSingletonList() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        list.add((Object)"1");
        long version = this.stm.getVersion();
        boolean result = list.remove((Object)"1");
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)0L, (long)list.size());
        Assert.assertEquals((Object)"[]", (Object)list.toString());
    }

    @Test
    public void remove_head() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        list.add((Object)"1");
        list.add((Object)"2");
        long version = this.stm.getVersion();
        boolean result = list.remove((Object)"1");
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"[2]", (Object)list.toString());
    }

    @Test
    public void removeTail() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        list.add((Object)"1");
        list.add((Object)"2");
        long version = this.stm.getVersion();
        boolean result = list.remove((Object)"2");
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"[1]", (Object)list.toString());
    }

    @Test
    public void remove_betweenHeadAndTail() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        list.add((Object)"1");
        list.add((Object)"2");
        list.add((Object)"3");
        list.add((Object)"4");
        list.add((Object)"5");
        long version = this.stm.getVersion();
        boolean result = list.remove((Object)"3");
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((Object)"[1, 2, 4, 5]", (Object)list.toString());
    }
}

