/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalLinkedList;

public class TransactionalLinkedList_setTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
    }

    @Test
    public void setFailsIfIndexOutOfBounds() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        list.add((Object)"1");
        this.setFailsIfIndexOutOfBounds((TransactionalLinkedList<String>)list, -1);
        this.setFailsIfIndexOutOfBounds((TransactionalLinkedList<String>)list, 1);
        this.setFailsIfIndexOutOfBounds((TransactionalLinkedList<String>)list, 2);
    }

    private void setFailsIfIndexOutOfBounds(TransactionalLinkedList<String> list, int index) {
        String original = list.toString();
        long version = this.stm.getVersion();
        try {
            list.get(index);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException ignore) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)original, (Object)list.toString());
    }

    @Test
    public void set() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        list.add((Object)"1");
        list.add((Object)"2");
        list.add((Object)"3");
        String result = (String)list.set(0, (Object)"a");
        Assert.assertEquals((Object)result, (Object)"1");
        Assert.assertEquals((Object)"[a, 2, 3]", (Object)list.toString());
        result = (String)list.set(1, (Object)"b");
        Assert.assertEquals((Object)result, (Object)"2");
        Assert.assertEquals((Object)"[a, b, 3]", (Object)list.toString());
    }
}

