/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.executors;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.executors.TransactionalThreadPoolExecutor;

public class TransactionalThreadPoolExecutor_StressTest {
    private TransactionalThreadPoolExecutor executor;
    private static final int scheduleCount = 5000000;
    private AtomicInteger runningCount;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.executor = new TransactionalThreadPoolExecutor();
        this.runningCount = new AtomicInteger(this.executor.getCorePoolSize());
    }

    @Test
    public void test() {
        long startNs = System.nanoTime();
        for (int k = 0; k < this.executor.getCorePoolSize(); ++k) {
            this.executor.execute((Runnable)new Command(k));
        }
        this.executor.awaitTerminationUninterruptibly();
        long durationNs = System.nanoTime() - startNs;
        double performance = 5000000.0 * (double)this.executor.getCorePoolSize() * (double)TimeUnit.SECONDS.toNanos(1L) / (double)durationNs;
        System.out.printf("Duration: %s ms\n", TimeUnit.NANOSECONDS.toMillis(durationNs));
        System.out.printf("Tasks executed: %s\n", 5000000 * this.executor.getCorePoolSize());
        System.out.printf("Performance: %s tasks/second\n", performance);
    }

    public class Command
    implements Runnable {
        private int count;
        private final int id;

        public Command(int id) {
            this.id = id;
        }

        @Override
        public void run() {
            ++this.count;
            if (this.count % 100000 == 0) {
                System.out.printf("Command %s is at %s\n", this.id, this.count);
            }
            if (this.count < 5000000) {
                TransactionalThreadPoolExecutor_StressTest.this.executor.execute((Runnable)this);
            } else if (TransactionalThreadPoolExecutor_StressTest.this.runningCount.decrementAndGet() == 0) {
                TransactionalThreadPoolExecutor_StressTest.this.executor.shutdown();
            }
        }
    }
}

