/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.executors;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalLinkedList;
import org.multiverse.transactional.collections.TransactionalQueue;
import org.multiverse.transactional.executors.TransactionalThreadPoolExecutor;
import org.multiverse.transactional.executors.TransactionalThreadPoolExecutorTestUtils;

public class TransactionalThreadPoolExecutor_constructorTest {
    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void withEmptyConstructor() {
        TransactionalThreadPoolExecutor executor = new TransactionalThreadPoolExecutor();
        TransactionalThreadPoolExecutorTestUtils.assertIsUnstarted(executor);
        Assert.assertTrue((boolean)(executor.getWorkQueue() instanceof TransactionalLinkedList));
    }

    @Test(expected=NullPointerException.class)
    public void withWorkQueue_whenWorkQueueNull_thenNullPointerException() {
        new TransactionalThreadPoolExecutor((TransactionalQueue)null);
    }

    @Test
    public void withWorkQueue() {
        TransactionalLinkedList workQueue = new TransactionalLinkedList();
        TransactionalThreadPoolExecutor executor = new TransactionalThreadPoolExecutor((TransactionalQueue)workQueue);
        TransactionalThreadPoolExecutorTestUtils.assertIsUnstarted(executor);
        Assert.assertSame((Object)workQueue, (Object)executor.getWorkQueue());
    }

    @Test
    public void withPoolSize() {
        TransactionalThreadPoolExecutor executor = new TransactionalThreadPoolExecutor(10);
        Assert.assertEquals((long)10L, (long)executor.getCorePoolSize());
        TransactionalThreadPoolExecutorTestUtils.assertIsUnstarted(executor);
    }

    @Test(expected=IllegalArgumentException.class)
    public void withPoolSize_whenPoolSizeNegative_thenIllegalArgumentException() {
        new TransactionalThreadPoolExecutor(-1);
    }
}

