/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.executors;

import java.util.concurrent.RejectedExecutionException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;
import org.multiverse.TestUtils;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.executors.TransactionalThreadPoolExecutor;
import org.multiverse.transactional.executors.TransactionalThreadPoolExecutorTestUtils;

public class TransactionalThreadPoolExecutor_executeTest {
    private TransactionalThreadPoolExecutor executor;
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor.awaitTerminationUninterruptibly();
        }
    }

    @Test
    public void whenTaskIsNull_thenNullPointerException() {
        this.executor = new TransactionalThreadPoolExecutor();
        this.executor.start();
        try {
            this.executor.execute(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        TransactionalThreadPoolExecutorTestUtils.assertIsStarted(this.executor);
    }

    @Test
    public void whenUnstarted_thenStartedAndTaskAccepted() {
        this.executor = new TransactionalThreadPoolExecutor();
        Runnable command = (Runnable)Mockito.mock(Runnable.class);
        this.executor.execute(command);
        TransactionalThreadPoolExecutorTestUtils.assertIsStarted(this.executor);
    }

    @Test
    public void whenStarted() {
        this.executor = new TransactionalThreadPoolExecutor();
        this.executor.start();
        Runnable task = (Runnable)Mockito.mock(Runnable.class);
        this.executor.execute(task);
        TestUtils.sleepMs((long)200L);
        TransactionalThreadPoolExecutorTestUtils.assertIsStarted(this.executor);
        ((Runnable)Mockito.verify((Object)task, (VerificationMode)Mockito.times((int)1))).run();
    }

    @Test
    public void whenShutdown_thenRejectedExecutionException() {
        this.executor = new TransactionalThreadPoolExecutor();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                TestUtils.sleepMs((long)1000L);
            }
        });
        this.executor.shutdown();
        Runnable task = (Runnable)Mockito.mock(Runnable.class);
        try {
            this.executor.execute(task);
            Assert.fail();
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        ((Runnable)Mockito.verify((Object)task, (VerificationMode)Mockito.never())).run();
    }

    @Test
    public void whenTerminated_thenRejectedExecutionException() {
        this.executor = new TransactionalThreadPoolExecutor();
        this.executor.shutdown();
        Runnable command = (Runnable)Mockito.mock(Runnable.class);
        try {
            this.executor.execute(command);
            Assert.fail();
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        TransactionalThreadPoolExecutorTestUtils.assertIsTerminated(this.executor);
    }
}

