/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.executors;

import java.util.Arrays;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.multiverse.TestUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.executors.TransactionalThreadPoolExecutor;
import org.multiverse.transactional.executors.TransactionalThreadPoolExecutorTestUtils;

public class TransactionalThreadPoolExecutor_shutdownNowTest {
    private TransactionalThreadPoolExecutor executor;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor.awaitTerminationUninterruptibly();
        }
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenUnstarted() {
        this.executor = new TransactionalThreadPoolExecutor();
        List tasks = this.executor.shutdownNow();
        Assert.assertNotNull((Object)tasks);
        Assert.assertTrue((boolean)tasks.isEmpty());
        TransactionalThreadPoolExecutorTestUtils.assertIsTerminated(this.executor);
    }

    @Test
    public void whenStarted() {
        this.executor = new TransactionalThreadPoolExecutor();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                TestUtils.sleepMs((long)100000L);
            }
        });
        TestUtils.sleepMs((long)500L);
        List sink = this.executor.shutdownNow();
        Assert.assertTrue((boolean)sink.isEmpty());
        TestUtils.sleepMs((long)500L);
        Assert.assertTrue((boolean)this.executor.isTerminated());
    }

    @Test
    @Ignore
    public void whenStartedAndPendingWork_thenPendingWorkReturned() {
        this.executor = new TransactionalThreadPoolExecutor();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                TestUtils.sleepMs((long)100000L);
            }
        });
        Runnable command = (Runnable)Mockito.mock(Runnable.class);
        this.executor.execute(command);
        TestUtils.sleepMs((long)500L);
        List sink = this.executor.shutdownNow();
        Assert.assertEquals(Arrays.asList(command), (Object)sink);
        TestUtils.sleepMs((long)500L);
        Assert.assertTrue((boolean)this.executor.isTerminated());
    }

    @Test
    public void whenShutdown_thenRunningTaskInterrupted() {
        this.executor = new TransactionalThreadPoolExecutor();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                TestUtils.sleepMs((long)100000L);
            }
        });
        this.executor.shutdown();
        this.executor.shutdownNow();
        TestUtils.sleepMs((long)300L);
        Assert.assertTrue((boolean)this.executor.isTerminated());
    }

    @Test
    @Ignore
    public void whenShutdownAndPendingWork_thenPendingReturned() {
        this.executor = new TransactionalThreadPoolExecutor();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                TestUtils.sleepMs((long)100000L);
            }
        });
        DummyTask command = new DummyTask();
        this.executor.execute((Runnable)command);
        TestUtils.sleepMs((long)500L);
        this.executor.shutdown();
        TestUtils.sleepMs((long)500L);
        List sink = this.executor.shutdownNow();
        Assert.assertEquals(Arrays.asList(command), (Object)sink);
        TestUtils.sleepMs((long)500L);
        Assert.assertTrue((boolean)this.executor.isTerminated());
    }

    @Test
    public void whenTerminated() {
        this.executor = new TransactionalThreadPoolExecutor();
        this.executor.shutdown();
        List tasks = this.executor.shutdownNow();
        Assert.assertNotNull((Object)tasks);
        Assert.assertTrue((boolean)tasks.isEmpty());
        TransactionalThreadPoolExecutorTestUtils.assertIsTerminated(this.executor);
    }

    class DummyTask
    implements Runnable {
        DummyTask() {
        }

        @Override
        public void run() {
        }
    }
}

