/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.executors;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.executors.TransactionalThreadPoolExecutor;
import org.multiverse.transactional.executors.TransactionalThreadPoolExecutorTestUtils;

public class TransactionalThreadPoolExecutor_shutdownTest {
    private Stm stm;
    private TransactionalThreadPoolExecutor executor;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        this.executor = new TransactionalThreadPoolExecutor();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor.awaitTerminationUninterruptibly();
        }
    }

    @Test
    public void whenUnstarted_thenTerminated() {
        this.executor.shutdown();
        TransactionalThreadPoolExecutorTestUtils.assertIsTerminated(this.executor);
    }

    @Test
    public void whenStartedButNoTaskRunning_thenTerminate() {
        this.executor.start();
        this.executor.shutdown();
        TestUtils.sleepMs((long)100L);
        Assert.assertTrue((boolean)this.executor.isTerminated());
    }

    @Test
    public void whenStartedAndTaskRunning_thenShutdown() {
        this.executor.start();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                TestUtils.sleepMs((long)1000L);
            }
        });
        this.executor.shutdown();
        TestUtils.sleepMs((long)100L);
        Assert.assertTrue((boolean)this.executor.isShutdown());
    }

    @Test
    public void whenShutdown_thenCallIgnored() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                TestUtils.sleepMs((long)1000L);
            }
        });
        this.executor.shutdown();
        this.executor.shutdown();
        Assert.assertTrue((boolean)this.executor.isShutdown());
    }

    @Test
    public void whenTerminated_thenCallIgnored() {
        this.executor.shutdown();
        this.executor.shutdown();
        long version = this.stm.getVersion();
        this.executor.shutdown();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        TransactionalThreadPoolExecutorTestUtils.assertIsTerminated(this.executor);
    }
}

