/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.executors;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.executors.TransactionalThreadPoolExecutor;
import org.multiverse.transactional.executors.TransactionalThreadPoolExecutorTestUtils;

public class TransactionalThreadPoolExecutor_startTest {
    private TransactionalThreadPoolExecutor executor;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor.awaitTerminationUninterruptibly();
        }
    }

    @Test
    public void whenUnstarted_thenInitialization() {
        this.executor = new TransactionalThreadPoolExecutor();
        this.executor.start();
        TransactionalThreadPoolExecutorTestUtils.assertIsStarted(this.executor);
        Assert.assertEquals((long)1L, (long)this.executor.getCurrentPoolSize());
    }

    @Test
    public void whenStarted_callIgnored() {
        this.executor = new TransactionalThreadPoolExecutor();
        this.executor.start();
        this.executor.start();
        TransactionalThreadPoolExecutorTestUtils.assertIsStarted(this.executor);
    }

    @Test
    public void whenShutdown_thenIllegalStateException() {
        this.executor = new TransactionalThreadPoolExecutor();
        this.executor.start();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                TestUtils.sleepMs((long)1000L);
            }
        });
        TestUtils.sleepMs((long)100L);
        this.executor.shutdown();
        try {
            this.executor.start();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.executor.isShutdown());
    }

    @Test
    public void whenTerminated_thenIllegalStateException() {
        this.executor = new TransactionalThreadPoolExecutor();
        this.executor.shutdown();
        try {
            this.executor.start();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        TransactionalThreadPoolExecutorTestUtils.assertIsTerminated(this.executor);
    }
}

