/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.primitives;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.transactional.primitives.TransactionalBoolean;
import org.multiverse.transactional.primitives.TransactionalCharacter;

public class TransactionalBooleanTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
    }

    @Test
    public void constructorWithNoArg() {
        TransactionalBoolean ref = new TransactionalBoolean();
        Assert.assertFalse((boolean)ref.get());
    }

    @Test
    public void constructorWithSingleArg() {
        Assert.assertTrue((boolean)new TransactionalBoolean(true).get());
        Assert.assertFalse((boolean)new TransactionalBoolean(false).get());
    }

    @Test
    public void set() {
        TransactionalCharacter ref = new TransactionalCharacter('\n');
        long old = ref.set('d');
        Assert.assertEquals((long)10L, (long)old);
        Assert.assertEquals((long)100L, (long)ref.get());
    }

    @Test
    public void testEquals() {
        TransactionalBoolean ref1 = new TransactionalBoolean(true);
        TransactionalBoolean ref2 = new TransactionalBoolean(true);
        TransactionalBoolean ref3 = new TransactionalBoolean(false);
        Assert.assertFalse((boolean)ref1.equals(null));
        Assert.assertFalse((boolean)ref1.equals((Object)""));
        Assert.assertTrue((boolean)ref1.equals((Object)ref2));
        Assert.assertTrue((boolean)ref2.equals((Object)ref1));
        Assert.assertTrue((boolean)ref1.equals((Object)ref1));
        Assert.assertFalse((boolean)ref1.equals((Object)ref3));
        Assert.assertFalse((boolean)ref3.equals((Object)ref1));
    }

    @Test
    public void testHashCode() {
        Assert.assertEquals((long)1L, (long)new TransactionalBoolean(true).hashCode());
        Assert.assertEquals((long)0L, (long)new TransactionalBoolean(false).hashCode());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"TransactionalBoolean(value=true)", (Object)new TransactionalBoolean(true).toString());
        Assert.assertEquals((Object)"TransactionalBoolean(value=false)", (Object)new TransactionalBoolean(false).toString());
    }

    @Test
    public void testAtomic() {
        TransactionalBoolean ref1 = new TransactionalBoolean(true);
        TransactionalBoolean ref2 = new TransactionalBoolean(false);
        try {
            this.flipButAbort(ref1, ref2);
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)ref1.get());
        Assert.assertFalse((boolean)ref2.get());
    }

    @TransactionalMethod
    public void flipButAbort(TransactionalBoolean ... refs) {
        for (TransactionalBoolean ref : refs) {
            ref.set(!ref.get());
        }
        ThreadLocalTransaction.getThreadLocalTransaction().abort();
    }
}

