/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.primitives;

import org.junit.Assert;
import org.junit.Test;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.transactional.primitives.TransactionalDouble;

public class TransactionalDoubleTest {
    @Test
    public void constructorWithNoArg() {
        TransactionalDouble ref = new TransactionalDouble();
        this.assertDoubleEquals(0.0, ref.get());
    }

    public void assertDoubleEquals(double expected, double found) {
        Assert.assertEquals((long)Double.doubleToLongBits(expected), (long)Double.doubleToLongBits(found));
    }

    @Test
    public void constructorWithSingleArg() {
        TransactionalDouble ref = new TransactionalDouble(10.0);
        this.assertDoubleEquals(10.0, ref.get());
    }

    @Test
    public void set() {
        TransactionalDouble ref = new TransactionalDouble();
        double old = ref.set(100.0);
        this.assertDoubleEquals(0.0, old);
        this.assertDoubleEquals(100.0, ref.get());
    }

    @Test
    public void testInc() {
        TransactionalDouble ref = new TransactionalDouble(100.0);
        this.assertDoubleEquals(101.0, ref.inc());
        this.assertDoubleEquals(101.0, ref.get());
        this.assertDoubleEquals(111.0, ref.inc(10.0));
        this.assertDoubleEquals(111.0, ref.get());
        this.assertDoubleEquals(100.0, ref.inc(-11.0));
        this.assertDoubleEquals(100.0, ref.get());
    }

    @Test
    public void testDec() {
        TransactionalDouble ref = new TransactionalDouble(100.0);
        this.assertDoubleEquals(99.0, ref.dec());
        this.assertDoubleEquals(99.0, ref.get());
        this.assertDoubleEquals(89.0, ref.dec(10.0));
        this.assertDoubleEquals(89.0, ref.get());
        this.assertDoubleEquals(100.0, ref.dec(-11.0));
        this.assertDoubleEquals(100.0, ref.get());
    }

    @Test
    public void testEquals() {
        TransactionalDouble ref1 = new TransactionalDouble(10.0);
        TransactionalDouble ref2 = new TransactionalDouble(10.0);
        TransactionalDouble ref3 = new TransactionalDouble(20.0);
        Assert.assertFalse((boolean)ref1.equals(null));
        Assert.assertFalse((boolean)ref1.equals((Object)""));
        Assert.assertTrue((boolean)ref1.equals((Object)ref2));
        Assert.assertTrue((boolean)ref2.equals((Object)ref1));
        Assert.assertTrue((boolean)ref1.equals((Object)ref1));
        Assert.assertFalse((boolean)ref1.equals((Object)ref3));
        Assert.assertFalse((boolean)ref3.equals((Object)ref1));
    }

    @Test
    public void testHashCode() {
        Assert.assertEquals((long)new Double(100.0).hashCode(), (long)new TransactionalDouble(100.0).hashCode());
        Assert.assertEquals((long)new Double(10.0).hashCode(), (long)new TransactionalDouble(10.0).hashCode());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"TransactionalDouble(value=10.0)", (Object)new TransactionalDouble(10.0).toString());
    }

    @Test
    public void testAtomic() {
        TransactionalDouble ref1 = new TransactionalDouble(10.0);
        TransactionalDouble ref2 = new TransactionalDouble(20.0);
        try {
            this.incButAbort(ref1, ref2);
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        this.assertDoubleEquals(10.0, ref1.get());
        this.assertDoubleEquals(20.0, ref2.get());
    }

    @TransactionalMethod
    public void incButAbort(TransactionalDouble ... refs) {
        for (TransactionalDouble ref : refs) {
            ref.inc();
        }
        ThreadLocalTransaction.getThreadLocalTransaction().abort();
    }
}

