/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.primitives;

import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.transactional.primitives.TransactionalInteger;

public class TransactionalLongStressTest {
    private int threadCount = 5;
    private int transactionCount = 2000000;
    private int refCount = 20;
    private TransactionalInteger[] refs;
    private AtomicInteger total = new AtomicInteger();
    private StressThread[] threads;

    @Before
    public void setUp() {
        int k;
        this.total.set(0);
        this.threads = new StressThread[this.threadCount];
        for (k = 0; k < this.threads.length; ++k) {
            this.threads[k] = new StressThread(k);
        }
        this.refs = new TransactionalInteger[this.refCount];
        for (k = 0; k < this.refs.length; ++k) {
            this.refs[k] = new TransactionalInteger(0);
        }
    }

    @Test
    public void test() {
        TestUtils.startAll((TestThread[])this.threads);
        TestUtils.joinAll((TestThread[])this.threads);
        Assert.assertEquals((long)this.total.get(), (long)this.sum());
    }

    public int sum() {
        int result = 0;
        for (TransactionalInteger ref : this.refs) {
            result += ref.get();
        }
        return result;
    }

    public class StressThread
    extends TestThread {
        public StressThread(int id) {
            super("StressThread-" + id);
        }

        public void doRun() throws Exception {
            for (int k = 0; k < TransactionalLongStressTest.this.transactionCount; ++k) {
                int count = this.doIt();
                TransactionalLongStressTest.this.total.addAndGet(count);
                if (k % 100000 != 0) continue;
                System.out.printf("%s is at %s\n", this.getName(), k);
            }
        }

        @TransactionalMethod
        private int doIt() {
            int count = 0;
            for (TransactionalInteger ref : TransactionalLongStressTest.this.refs) {
                if (TestUtils.randomInt((int)10) % 5 != 2) continue;
                ++count;
                ref.inc();
            }
            return count;
        }
    }
}

