/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha;

import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import org.multiverse.api.Stm;
import org.multiverse.api.TransactionFactory;
import org.multiverse.api.TransactionFactoryBuilder;
import org.multiverse.api.backoff.BackoffPolicy;
import org.multiverse.api.clock.PrimitiveClock;
import org.multiverse.api.commitlock.CommitLockPolicy;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticReferenceFactoryBuilder;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.stms.alpha.transactions.SpeculativeConfiguration;
import org.multiverse.stms.alpha.transactions.readonly.ArrayReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.MapReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.MonoReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.NonTrackingReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.ReadonlyConfiguration;
import org.multiverse.stms.alpha.transactions.update.ArrayUpdateAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.MapUpdateAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.MonoUpdateAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.UpdateConfiguration;

public final class AlphaStm
implements Stm<AlphaTransactionFactoryBuilder, AlphaProgrammaticReferenceFactoryBuilder> {
    private static final Logger logger = Logger.getLogger(AlphaStm.class.getName());
    private static final AtomicLong anonoymousFamilyNameGenerator = new AtomicLong();
    private final PrimitiveClock clock;
    private final CommitLockPolicy commitLockPolicy;
    private final BackoffPolicy backoffPolicy;
    private final int maxRetries;
    private final int maxArraySize;
    private final boolean speculativeConfigEnabled;
    private final boolean optimizeConflictDetectionEnabled;
    private final boolean dirtyCheckEnabled;
    private final boolean quickReleaseWriteLocksEnabled;
    private final boolean explicitRetryAllowed;
    private final boolean readTrackingEnabled;
    private final boolean allowWriteSkew;
    private final boolean interruptible;
    private final AlphaProgrammaticReferenceFactoryBuilder referenceFactoryBuilder;
    private final int maxReadSpinCount;
    private final boolean loggingOfControlFlowErrorsEnabled;

    private static String createAnonymousFamilyName() {
        return "TransactionFamily-" + anonoymousFamilyNameGenerator.incrementAndGet();
    }

    public static AlphaStm createFast() {
        return new AlphaStm(AlphaStmConfig.createFastConfig());
    }

    public static AlphaStm createDebug() {
        return new AlphaStm(AlphaStmConfig.createDebugConfig());
    }

    public AlphaStm() {
        this(AlphaStmConfig.createFastConfig());
    }

    public AlphaStm(AlphaStmConfig config) {
        if (config == null) {
            throw new NullPointerException();
        }
        config.ensureValid();
        this.speculativeConfigEnabled = config.speculativeConfigurationEnabled;
        this.optimizeConflictDetectionEnabled = config.optimizedConflictDetectionEnabled;
        this.dirtyCheckEnabled = config.dirtyCheckEnabled;
        this.maxArraySize = config.maxFixedUpdateSize;
        this.commitLockPolicy = config.commitLockPolicy;
        this.backoffPolicy = config.backoffPolicy;
        this.maxRetries = config.maxRetries;
        this.clock = config.clock;
        this.quickReleaseWriteLocksEnabled = config.quickReleaseWriteLocksEnabled;
        this.referenceFactoryBuilder = new AlphaProgrammaticReferenceFactoryBuilder(this);
        this.explicitRetryAllowed = config.explicitRetryAllowed;
        this.readTrackingEnabled = config.readTrackingEnabled;
        this.allowWriteSkew = config.allowWriteSkew;
        this.interruptible = config.interruptible;
        this.maxReadSpinCount = config.maxReadSpinCount;
        this.loggingOfControlFlowErrorsEnabled = config.loggingOfControlFlowErrorsEnabled;
        if (this.clock.getVersion() == 0L) {
            this.clock.tick();
        }
        logger.info("Created a new AlphaStm instance");
    }

    public AlphaTransactionFactoryBuilder getTransactionFactoryBuilder() {
        return new AlphaTransactionFactoryBuilder();
    }

    public int getMaxReadSpinCount() {
        return this.maxReadSpinCount;
    }

    public CommitLockPolicy getAtomicObjectLockPolicy() {
        return this.commitLockPolicy;
    }

    public BackoffPolicy getBackoffPolicy() {
        return this.backoffPolicy;
    }

    public CommitLockPolicy getCommitLockPolicy() {
        return this.commitLockPolicy;
    }

    public boolean isDirtyCheckEnabled() {
        return this.dirtyCheckEnabled;
    }

    public int getMaxArraySize() {
        return this.maxArraySize;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public boolean isOptimizeConflictDetectionEnabled() {
        return this.optimizeConflictDetectionEnabled;
    }

    public boolean isQuickReleaseWriteLocksEnabled() {
        return this.quickReleaseWriteLocksEnabled;
    }

    public boolean isSpeculativeConfigEnabled() {
        return this.speculativeConfigEnabled;
    }

    public long getVersion() {
        return this.clock.getVersion();
    }

    public PrimitiveClock getClock() {
        return this.clock;
    }

    public AlphaProgrammaticReferenceFactoryBuilder getProgrammaticReferenceFactoryBuilder() {
        return this.referenceFactoryBuilder;
    }

    public class AlphaTransactionFactoryBuilder
    implements TransactionFactoryBuilder<AlphaTransaction, AlphaTransactionFactoryBuilder> {
        private final int maxRetries;
        private final boolean readonly;
        private final String familyName;
        private final boolean readTrackingEnabled;
        private final boolean writeSkewAllowed;
        private final CommitLockPolicy commitLockPolicy;
        private final BackoffPolicy backoffPolicy;
        private final SpeculativeConfiguration speculativeConfig;
        private final boolean interruptible;
        private final boolean dirtyCheck;
        private final boolean quickReleaseEnabled;
        private final boolean explicitRetryAllowed;
        private final long timeoutNs;
        private final int maxReadSpinCount;

        public AlphaTransactionFactoryBuilder() {
            this(false, alphaStm.readTrackingEnabled, AlphaStm.createAnonymousFamilyName(), alphaStm.maxRetries, alphaStm.allowWriteSkew, alphaStm.commitLockPolicy, alphaStm.backoffPolicy, SpeculativeConfiguration.createSpeculativeConfiguration(alphaStm.speculativeConfigEnabled, alphaStm.maxArraySize), alphaStm.interruptible, alphaStm.dirtyCheckEnabled, alphaStm.quickReleaseWriteLocksEnabled, alphaStm.explicitRetryAllowed, Long.MAX_VALUE, alphaStm.maxReadSpinCount);
        }

        public AlphaTransactionFactoryBuilder(boolean readonly, boolean readTrackingEnabled, String familyName, int maxRetries, boolean writeSkewAllowed, CommitLockPolicy commitLockPolicy, BackoffPolicy backoffPolicy, SpeculativeConfiguration speculativeConfig, boolean interruptible, boolean dirtyCheck, boolean quickReleaseEnabled, boolean explicitRetryAllowed, long timeoutNs, int maxReadSpinCount) {
            this.readonly = readonly;
            this.familyName = familyName;
            this.maxRetries = maxRetries;
            this.readTrackingEnabled = readTrackingEnabled;
            this.writeSkewAllowed = writeSkewAllowed;
            this.commitLockPolicy = commitLockPolicy;
            this.backoffPolicy = backoffPolicy;
            this.speculativeConfig = speculativeConfig;
            this.interruptible = interruptible;
            this.dirtyCheck = dirtyCheck;
            this.quickReleaseEnabled = quickReleaseEnabled;
            this.explicitRetryAllowed = explicitRetryAllowed;
            this.timeoutNs = timeoutNs;
            this.maxReadSpinCount = maxReadSpinCount;
        }

        public BackoffPolicy getBackoffPolicy() {
            return this.backoffPolicy;
        }

        public boolean isDirtyCheckEnabled() {
            return AlphaStm.this.dirtyCheckEnabled;
        }

        public boolean isExplicitRetryAllowed() {
            return this.explicitRetryAllowed;
        }

        public String getFamilyName() {
            return this.familyName;
        }

        public boolean isReadonly() {
            return this.readonly;
        }

        public boolean isReadTrackingEnabled() {
            return this.readTrackingEnabled;
        }

        public boolean isInterruptible() {
            return this.interruptible;
        }

        public CommitLockPolicy getCommitLockPolicy() {
            return this.commitLockPolicy;
        }

        public boolean isSpeculativeConfigurationEnabled() {
            return AlphaStm.this.speculativeConfigEnabled;
        }

        public boolean isWriteSkewAllowed() {
            return this.writeSkewAllowed;
        }

        public boolean isQuickReleaseEnabled() {
            return this.quickReleaseEnabled;
        }

        public long getTimeoutNs() {
            return this.timeoutNs;
        }

        public int getMaxRetries() {
            return this.maxRetries;
        }

        public int getMaxReadSpinCount() {
            return this.maxReadSpinCount;
        }

        public AlphaTransactionFactoryBuilder setMaxReadSpinCount(int maxReadSpinCount) {
            if (maxReadSpinCount < 0) {
                throw new IllegalArgumentException();
            }
            return new AlphaTransactionFactoryBuilder(this.readonly, this.readTrackingEnabled, this.familyName, this.maxRetries, this.writeSkewAllowed, this.commitLockPolicy, this.backoffPolicy, this.speculativeConfig, this.interruptible, this.dirtyCheck, this.quickReleaseEnabled, this.explicitRetryAllowed, this.timeoutNs, maxReadSpinCount);
        }

        public AlphaTransactionFactoryBuilder setTimeoutNs(long timeoutNs) {
            if (timeoutNs < 0L) {
                throw new IllegalArgumentException();
            }
            return new AlphaTransactionFactoryBuilder(this.readonly, this.readTrackingEnabled, this.familyName, this.maxRetries, this.writeSkewAllowed, this.commitLockPolicy, this.backoffPolicy, this.speculativeConfig, this.interruptible, this.dirtyCheck, this.quickReleaseEnabled, this.explicitRetryAllowed, timeoutNs, this.maxReadSpinCount);
        }

        public AlphaTransactionFactoryBuilder setFamilyName(String familyName) {
            return new AlphaTransactionFactoryBuilder(this.readonly, this.readTrackingEnabled, familyName, this.maxRetries, this.writeSkewAllowed, this.commitLockPolicy, this.backoffPolicy, this.speculativeConfig, this.interruptible, this.dirtyCheck, this.quickReleaseEnabled, this.explicitRetryAllowed, this.timeoutNs, this.maxReadSpinCount);
        }

        public AlphaTransactionFactoryBuilder setQuickReleaseEnabled(boolean quickReleaseEnabled) {
            return new AlphaTransactionFactoryBuilder(this.readonly, this.readTrackingEnabled, this.familyName, this.maxRetries, this.writeSkewAllowed, this.commitLockPolicy, this.backoffPolicy, this.speculativeConfig, this.interruptible, this.dirtyCheck, quickReleaseEnabled, this.explicitRetryAllowed, this.timeoutNs, this.maxReadSpinCount);
        }

        public AlphaTransactionFactoryBuilder setMaxRetries(int maxRetries) {
            if (maxRetries < 0) {
                throw new IllegalArgumentException(String.format("retryCount can't be smaller than 0, found %s", maxRetries));
            }
            return new AlphaTransactionFactoryBuilder(this.readonly, this.readTrackingEnabled, this.familyName, maxRetries, this.writeSkewAllowed, this.commitLockPolicy, this.backoffPolicy, this.speculativeConfig, this.interruptible, this.dirtyCheck, this.quickReleaseEnabled, this.explicitRetryAllowed, this.timeoutNs, this.maxReadSpinCount);
        }

        public AlphaTransactionFactoryBuilder setReadonly(boolean readonly) {
            SpeculativeConfiguration newSpeculativeConfig = this.speculativeConfig.withSpeculativeReadonlyDisabled();
            return new AlphaTransactionFactoryBuilder(readonly, this.readTrackingEnabled, this.familyName, this.maxRetries, this.writeSkewAllowed, this.commitLockPolicy, this.backoffPolicy, newSpeculativeConfig, this.interruptible, this.dirtyCheck, this.quickReleaseEnabled, this.explicitRetryAllowed, this.timeoutNs, this.maxReadSpinCount);
        }

        public AlphaTransactionFactoryBuilder setReadTrackingEnabled(boolean readTrackingEnabled) {
            SpeculativeConfiguration newSpeculativeConfig = this.speculativeConfig.withSpeculativeNonAutomaticReadTrackingDisabled();
            return new AlphaTransactionFactoryBuilder(this.readonly, readTrackingEnabled, this.familyName, this.maxRetries, this.writeSkewAllowed, this.commitLockPolicy, this.backoffPolicy, newSpeculativeConfig, this.interruptible, this.dirtyCheck, this.quickReleaseEnabled, this.explicitRetryAllowed, this.timeoutNs, this.maxReadSpinCount);
        }

        public AlphaTransactionFactoryBuilder setInterruptible(boolean interruptible) {
            return new AlphaTransactionFactoryBuilder(this.readonly, this.readTrackingEnabled, this.familyName, this.maxRetries, this.writeSkewAllowed, this.commitLockPolicy, this.backoffPolicy, this.speculativeConfig, interruptible, this.dirtyCheck, this.quickReleaseEnabled, this.explicitRetryAllowed, this.timeoutNs, this.maxReadSpinCount);
        }

        public AlphaTransactionFactoryBuilder setCommitLockPolicy(CommitLockPolicy commitLockPolicy) {
            if (commitLockPolicy == null) {
                throw new NullPointerException();
            }
            return new AlphaTransactionFactoryBuilder(this.readonly, this.readTrackingEnabled, this.familyName, this.maxRetries, this.writeSkewAllowed, commitLockPolicy, this.backoffPolicy, this.speculativeConfig, this.interruptible, this.dirtyCheck, this.quickReleaseEnabled, this.explicitRetryAllowed, this.timeoutNs, this.maxReadSpinCount);
        }

        public AlphaTransactionFactoryBuilder setSpeculativeConfigurationEnabled(boolean enabled) {
            SpeculativeConfiguration newSpeculativeConfig = SpeculativeConfiguration.createSpeculativeConfiguration(enabled, AlphaStm.this.maxArraySize);
            return new AlphaTransactionFactoryBuilder(this.readonly, this.readTrackingEnabled, this.familyName, this.maxRetries, this.writeSkewAllowed, this.commitLockPolicy, this.backoffPolicy, newSpeculativeConfig, this.interruptible, this.dirtyCheck, this.quickReleaseEnabled, this.explicitRetryAllowed, this.timeoutNs, this.maxReadSpinCount);
        }

        public AlphaTransactionFactoryBuilder setWriteSkewAllowed(boolean allowWriteSkew) {
            return new AlphaTransactionFactoryBuilder(this.readonly, this.readTrackingEnabled, this.familyName, this.maxRetries, allowWriteSkew, this.commitLockPolicy, this.backoffPolicy, this.speculativeConfig, this.interruptible, this.dirtyCheck, this.quickReleaseEnabled, this.explicitRetryAllowed, this.timeoutNs, this.maxReadSpinCount);
        }

        public AlphaTransactionFactoryBuilder setBackoffPolicy(BackoffPolicy backoffPolicy) {
            if (backoffPolicy == null) {
                throw new NullPointerException();
            }
            return new AlphaTransactionFactoryBuilder(this.readonly, this.readTrackingEnabled, this.familyName, this.maxRetries, this.writeSkewAllowed, this.commitLockPolicy, backoffPolicy, this.speculativeConfig, this.interruptible, this.dirtyCheck, this.quickReleaseEnabled, this.explicitRetryAllowed, this.timeoutNs, this.maxReadSpinCount);
        }

        public AlphaTransactionFactoryBuilder setDirtyCheckEnabled(boolean dirtyCheckEnabled) {
            return new AlphaTransactionFactoryBuilder(this.readonly, this.readTrackingEnabled, this.familyName, this.maxRetries, this.writeSkewAllowed, this.commitLockPolicy, this.backoffPolicy, this.speculativeConfig, this.interruptible, dirtyCheckEnabled, this.quickReleaseEnabled, this.explicitRetryAllowed, this.timeoutNs, this.maxReadSpinCount);
        }

        public AlphaTransactionFactoryBuilder setExplicitRetryAllowed(boolean explicitRetryAllowed) {
            return new AlphaTransactionFactoryBuilder(this.readonly, this.readTrackingEnabled, this.familyName, this.maxRetries, this.writeSkewAllowed, this.commitLockPolicy, this.backoffPolicy, this.speculativeConfig, this.interruptible, this.dirtyCheck, this.quickReleaseEnabled, explicitRetryAllowed, this.timeoutNs, this.maxReadSpinCount);
        }

        public TransactionFactory<AlphaTransaction> build() {
            if (this.speculativeConfig.isEnabled()) {
                return this.createSpeculativeTxFactory();
            }
            if (this.readonly) {
                return this.createNonSpeculativeReadonlyTxFactory();
            }
            return this.createNonSpeculativeUpdateTxFactory();
        }

        private TransactionFactory<AlphaTransaction> createSpeculativeTxFactory() {
            final ReadonlyConfiguration ro_nort = new ReadonlyConfiguration(AlphaStm.this.clock, this.backoffPolicy, this.familyName, this.speculativeConfig, this.maxRetries, this.interruptible, false, this.explicitRetryAllowed, this.timeoutNs, this.maxReadSpinCount);
            final ReadonlyConfiguration ro_rt = new ReadonlyConfiguration(AlphaStm.this.clock, this.backoffPolicy, this.familyName, this.speculativeConfig, this.maxRetries, this.interruptible, true, this.explicitRetryAllowed, this.timeoutNs, this.maxReadSpinCount);
            final UpdateConfiguration up_rt = new UpdateConfiguration(AlphaStm.this.clock, this.backoffPolicy, this.commitLockPolicy, this.familyName, this.speculativeConfig, this.maxRetries, this.interruptible, true, this.writeSkewAllowed, AlphaStm.this.optimizeConflictDetectionEnabled, true, this.quickReleaseEnabled, this.explicitRetryAllowed, this.timeoutNs, this.maxReadSpinCount);
            final UpdateConfiguration up_nort = new UpdateConfiguration(AlphaStm.this.clock, this.backoffPolicy, this.commitLockPolicy, this.familyName, this.speculativeConfig, this.maxRetries, this.interruptible, false, true, AlphaStm.this.optimizeConflictDetectionEnabled, true, this.quickReleaseEnabled, this.explicitRetryAllowed, this.timeoutNs, this.maxReadSpinCount);
            return new TransactionFactory<AlphaTransaction>(){

                public TransactionFactoryBuilder getBuilder() {
                    return AlphaTransactionFactoryBuilder.this;
                }

                public AlphaTransaction start() {
                    boolean finalReadonly = AlphaTransactionFactoryBuilder.this.speculativeConfig.isSpeculativeReadonlyEnabled() ? AlphaTransactionFactoryBuilder.this.speculativeConfig.isReadonly() : AlphaTransactionFactoryBuilder.this.readonly;
                    boolean finalAutomaticReadTracking = AlphaTransactionFactoryBuilder.this.speculativeConfig.isSpeculativeNoReadTrackingEnabled() ? AlphaTransactionFactoryBuilder.this.speculativeConfig.isReadTrackingEnabled() : AlphaTransactionFactoryBuilder.this.readTrackingEnabled;
                    boolean speculativeSizeEnabled = AlphaTransactionFactoryBuilder.this.speculativeConfig.isSpeculativeSizeEnabled();
                    if (finalReadonly) {
                        if (finalAutomaticReadTracking) {
                            if (speculativeSizeEnabled) {
                                int size = AlphaTransactionFactoryBuilder.this.speculativeConfig.getOptimalSize();
                                if (size <= 1) {
                                    return new MonoReadonlyAlphaTransaction(ro_rt);
                                }
                                if (size < AlphaStm.this.maxArraySize) {
                                    return new ArrayReadonlyAlphaTransaction(ro_rt, size);
                                }
                                return new MapReadonlyAlphaTransaction(ro_rt);
                            }
                            return new MapReadonlyAlphaTransaction(ro_rt);
                        }
                        return new NonTrackingReadonlyAlphaTransaction(ro_nort);
                    }
                    UpdateConfiguration config = finalAutomaticReadTracking ? up_rt : up_nort;
                    if (speculativeSizeEnabled) {
                        int size = AlphaTransactionFactoryBuilder.this.speculativeConfig.getOptimalSize();
                        if (size <= 1) {
                            return new MonoUpdateAlphaTransaction(config);
                        }
                        if (size <= AlphaStm.this.maxArraySize) {
                            return new ArrayUpdateAlphaTransaction(config, size);
                        }
                        return new MapUpdateAlphaTransaction(config);
                    }
                    return new MapUpdateAlphaTransaction(config);
                }
            };
        }

        private TransactionFactory<AlphaTransaction> createNonSpeculativeReadonlyTxFactory() {
            ReadonlyConfiguration config = new ReadonlyConfiguration(AlphaStm.this.clock, this.backoffPolicy, this.familyName, this.speculativeConfig, this.maxRetries, this.interruptible, this.readTrackingEnabled, this.explicitRetryAllowed, this.timeoutNs, this.maxReadSpinCount);
            if (this.readTrackingEnabled) {
                return new MapReadonlyAlphaTransaction.Factory(config, this);
            }
            return new NonTrackingReadonlyAlphaTransaction.Factory(config, this);
        }

        private TransactionFactory<AlphaTransaction> createNonSpeculativeUpdateTxFactory() {
            if (!this.readTrackingEnabled && !this.writeSkewAllowed) {
                String msg = String.format("Can't createReference transactionfactory for transaction family '%s' because an update transaction without automaticReadTracking and without isWriteSkewAllowed is not possible", this.familyName);
                throw new IllegalStateException(msg);
            }
            UpdateConfiguration config = new UpdateConfiguration(AlphaStm.this.clock, this.backoffPolicy, this.commitLockPolicy, this.familyName, this.speculativeConfig, this.maxRetries, this.interruptible, this.readTrackingEnabled, this.writeSkewAllowed, AlphaStm.this.optimizeConflictDetectionEnabled, true, this.quickReleaseEnabled, this.explicitRetryAllowed, this.timeoutNs, this.maxReadSpinCount);
            return new MapUpdateAlphaTransaction.Factory(config, this);
        }
    }
}

