/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.mixins;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.multiverse.MultiverseConstants;
import org.multiverse.api.Listeners;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.LockNotFreeReadConflict;
import org.multiverse.api.exceptions.OldVersionNotFoundReadConflict;
import org.multiverse.api.exceptions.PanicError;
import org.multiverse.api.latches.Latch;
import org.multiverse.stms.alpha.AlphaStmUtils;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.RegisterRetryListenerResult;
import org.multiverse.utils.TodoException;

public abstract class DefaultTxObjectMixin
implements AlphaTransactionalObject,
MultiverseConstants {
    private static final AtomicReferenceFieldUpdater<DefaultTxObjectMixin, Transaction> ___LOCKOWNER_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DefaultTxObjectMixin.class, Transaction.class, "___lockOwner");
    private static final AtomicReferenceFieldUpdater<DefaultTxObjectMixin, AlphaTranlocal> ___TRANLOCAL_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DefaultTxObjectMixin.class, AlphaTranlocal.class, "___tranlocal");
    private static final AtomicReferenceFieldUpdater<DefaultTxObjectMixin, Listeners> ___LISTENERS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DefaultTxObjectMixin.class, Listeners.class, "___listeners");
    private volatile Transaction ___lockOwner;
    private volatile AlphaTranlocal ___tranlocal;
    private volatile Listeners ___listeners;

    @Override
    public AlphaTranlocal ___load() {
        return ___TRANLOCAL_UPDATER.get(this);
    }

    @Override
    public AlphaTranlocal ___load(long readVersion) {
        boolean noConflictingWrites;
        AlphaTranlocal tranlocalTime1 = ___TRANLOCAL_UPDATER.get(this);
        if (tranlocalTime1 == null) {
            return null;
        }
        if (___SANITY_CHECKS_ENABLED && tranlocalTime1.isUncommitted()) {
            throw new PanicError();
        }
        if (tranlocalTime1.getWriteVersion() == readVersion) {
            return tranlocalTime1;
        }
        if (tranlocalTime1.getWriteVersion() > readVersion) {
            throw this.createOldVersionNotFoundReadConflict(readVersion, tranlocalTime1);
        }
        Transaction lockOwner = ___LOCKOWNER_UPDATER.get(this);
        if (lockOwner != null) {
            throw this.createLockNotFreeReadConflict();
        }
        AlphaTranlocal tranlocalTime2 = ___TRANLOCAL_UPDATER.get(this);
        boolean bl = noConflictingWrites = tranlocalTime2 == tranlocalTime1;
        if (noConflictingWrites) {
            return tranlocalTime1;
        }
        if (tranlocalTime2.getWriteVersion() == readVersion) {
            return tranlocalTime2;
        }
        throw this.createOldVersionNotFoundReadConflict(readVersion, tranlocalTime2);
    }

    private LockNotFreeReadConflict createLockNotFreeReadConflict() {
        if (LockNotFreeReadConflict.reuse) {
            return LockNotFreeReadConflict.INSTANCE;
        }
        String msg = String.format("Failed to load already locked transactionalobject '%s'", AlphaStmUtils.toTxObjectString(this));
        return new LockNotFreeReadConflict(msg);
    }

    private OldVersionNotFoundReadConflict createOldVersionNotFoundReadConflict(long readVersion, AlphaTranlocal tranlocalTime2) {
        if (OldVersionNotFoundReadConflict.reuse) {
            return OldVersionNotFoundReadConflict.INSTANCE;
        }
        String msg = String.format("Can't load version '%s' transactionalobject '%s', the oldest version found is '%s'", readVersion, AlphaStmUtils.toTxObjectString(this), tranlocalTime2.getWriteVersion());
        return new OldVersionNotFoundReadConflict(msg);
    }

    @Override
    public AlphaTranlocal ___openForCommutingOperation() {
        throw new TodoException();
    }

    @Override
    public Listeners ___storeUpdate(AlphaTranlocal tranlocal, long writeVersion, boolean releaseLock) {
        assert (tranlocal != null);
        if (___SANITY_CHECKS_ENABLED) {
            if (this.___lockOwner == null) {
                String msg = String.format("Lock on transactionalObject '%s' is not hold while doing the store", AlphaStmUtils.toTxObjectString(this));
                throw new PanicError(msg);
            }
            if (tranlocal.getWriteVersion() >= writeVersion) {
                String msg = String.format("The tranlocal of transactionalObject '%s' has version '%s'  and and is too large for writeVersion '%s'", AlphaStmUtils.toTxObjectString(this), tranlocal.getTransactionalObject(), writeVersion);
                throw new PanicError(msg);
            }
            AlphaTranlocal old = ___TRANLOCAL_UPDATER.get(this);
            if (old != null && old.getWriteVersion() >= writeVersion) {
                String msg = String.format("The current version '%s' is newer than the version '%s' to commit for transactionalobject '%s''", old.getWriteVersion(), writeVersion, tranlocal.getWriteVersion());
                throw new PanicError(msg);
            }
        }
        tranlocal.prepareForCommit(writeVersion);
        ___TRANLOCAL_UPDATER.set(this, tranlocal);
        Listeners listeners = null;
        if (___LISTENERS_UPDATER.get(this) != null) {
            listeners = ___LISTENERS_UPDATER.getAndSet(this, null);
        }
        if (releaseLock) {
            ___LOCKOWNER_UPDATER.set(this, null);
        }
        return listeners;
    }

    @Override
    public void ___storeInitial(AlphaTranlocal tranlocal, long writeVersion) {
        tranlocal.prepareForCommit(writeVersion);
        ___TRANLOCAL_UPDATER.set(this, tranlocal);
    }

    public Transaction ___getLockOwner() {
        return this.___lockOwner;
    }

    public boolean ___tryLock(Transaction lockOwner) {
        return ___LOCKOWNER_UPDATER.compareAndSet(this, null, lockOwner);
    }

    public void ___releaseLock(Transaction expectedLockOwner) {
        if (___LOCKOWNER_UPDATER.get(this) == expectedLockOwner) {
            ___LOCKOWNER_UPDATER.set(this, null);
        }
    }

    public Listeners ___getListeners() {
        return this.___listeners;
    }

    @Override
    public RegisterRetryListenerResult ___registerRetryListener(Latch listener, long minimumWakeupVersion) {
        AlphaTranlocal tranlocalT2;
        Listeners newListeners;
        Listeners oldListeners;
        boolean placedListener;
        AlphaTranlocal tranlocalT1 = ___TRANLOCAL_UPDATER.get(this);
        if (tranlocalT1 == null) {
            return RegisterRetryListenerResult.noregistration;
        }
        if (tranlocalT1.getWriteVersion() >= minimumWakeupVersion) {
            listener.open();
            return RegisterRetryListenerResult.opened;
        }
        do {
            if ((placedListener = ___LISTENERS_UPDATER.compareAndSet(this, oldListeners = ___LISTENERS_UPDATER.get(this), newListeners = new Listeners(listener, oldListeners))) || tranlocalT1 == (tranlocalT2 = ___TRANLOCAL_UPDATER.get(this))) continue;
            if (___SANITY_CHECKS_ENABLED) {
                if (tranlocalT2.getWriteVersion() <= tranlocalT1.getWriteVersion()) {
                    String msg = String.format("Going back in time; transactionalobject '%s' and tranlocalT2 with version '%s' has a smaller version than tranlocalT2 with version '%s'", AlphaStmUtils.toTxObjectString(this), tranlocalT1.getWriteVersion(), tranlocalT2.getWriteVersion());
                    throw new PanicError(msg);
                }
                if (minimumWakeupVersion > tranlocalT2.getWriteVersion()) {
                    String msg = String.format("Minimum version '%s' for registerRetryListener on transactionalobject '%s' is larger than tranlocalT2.version '%s'", minimumWakeupVersion, AlphaStmUtils.toTxObjectString(this), tranlocalT2.getWriteVersion());
                    throw new PanicError(msg);
                }
            }
            listener.open();
            return RegisterRetryListenerResult.opened;
        } while (!placedListener);
        tranlocalT2 = ___TRANLOCAL_UPDATER.get(this);
        if (tranlocalT1 != tranlocalT2) {
            if (___SANITY_CHECKS_ENABLED && tranlocalT2.getWriteVersion() < minimumWakeupVersion) {
                String msg = String.format("TranlocalT2 with version '%s' for registerRetryListener on transactionalobject '%s' is smaller than minimumWakeupVersion '%s'", tranlocalT2.getWriteVersion(), AlphaStmUtils.toTxObjectString(this), minimumWakeupVersion);
                throw new PanicError(msg);
            }
            listener.open();
            ___LISTENERS_UPDATER.compareAndSet(this, newListeners, oldListeners);
        }
        return RegisterRetryListenerResult.registered;
    }
}

