/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.benchmarks;

import java.util.concurrent.TimeUnit;
import org.benchy.AbstractBenchmarkDriver;
import org.benchy.TestCase;
import org.benchy.TestCaseResult;
import org.junit.Assert;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.transactional.primitives.TransactionalInteger;

public class NonConcurrentUpdateDriver
extends AbstractBenchmarkDriver {
    private int incCountPerThread;
    private int threadCount;
    private IncThread[] threads;
    private TransactionalInteger[] refs;

    public void preRun(TestCase testCase) {
        this.incCountPerThread = testCase.getIntProperty("incCountPerThread");
        this.threadCount = testCase.getIntProperty("threadCount");
        this.refs = new TransactionalInteger[this.threadCount];
        this.threads = new IncThread[this.threadCount];
        for (int k = 0; k < this.threads.length; ++k) {
            this.refs[k] = new TransactionalInteger();
            this.threads[k] = new IncThread(k, this.refs[k]);
        }
    }

    public void run() {
        TestUtils.startAll((TestThread[])this.threads);
        TestUtils.joinAll((TestThread[])this.threads);
        Assert.assertEquals((long)(this.incCountPerThread * this.threadCount), (long)this.sum());
    }

    public void postRun(TestCaseResult caseResult) {
        int transactionCount = this.incCountPerThread * this.threadCount;
        caseResult.put("transactionCount", (Object)transactionCount);
        double transactionsPerSecond = 1.0 * (double)transactionCount * (double)TimeUnit.SECONDS.toNanos(1L) / (double)caseResult.getLongProperty("duration(ns)");
        caseResult.put("transactions/s", (Object)transactionsPerSecond);
        double transactionsPerSecondPerThread = transactionsPerSecond / (double)this.threadCount;
        caseResult.put("transactions/s/thread", (Object)transactionsPerSecondPerThread);
    }

    private int sum() {
        int result = 0;
        for (TransactionalInteger ref : this.refs) {
            result += ref.get();
        }
        return result;
    }

    public class IncThread
    extends TestThread {
        private TransactionalInteger intRef;

        public IncThread(int id, TransactionalInteger intRef2) {
            super("IncThread-" + id);
            this.intRef = intRef2;
        }

        public void doRun() throws Exception {
            for (int k = 0; k < NonConcurrentUpdateDriver.this.incCountPerThread; ++k) {
                if (k % 1000000 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), k);
                }
                this.intRef.inc();
            }
        }
    }
}

