/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.benchmarks;

import org.benchy.AbstractBenchmarkDriver;
import org.benchy.TestCase;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.primitives.TransactionalInteger;

public class ReadPerformanceDriver
extends AbstractBenchmarkDriver {
    private int incCountPerThread;
    private int threadCount;
    private boolean readonly;
    private ReadThread[] threads;
    private TransactionalInteger ref;

    public void preRun(TestCase testCase) {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.incCountPerThread = testCase.getIntProperty("readCountPerThread");
        this.threadCount = testCase.getIntProperty("threadCount");
        this.readonly = testCase.getBooleanProperty("readonly");
        this.threads = new ReadThread[this.threadCount];
        for (int k = 0; k < this.threads.length; ++k) {
            this.threads[k] = new ReadThread(k);
        }
        this.ref = new TransactionalInteger();
    }

    public void run() {
        TestUtils.startAll((TestThread[])this.threads);
        TestUtils.joinAll((TestThread[])this.threads);
    }

    public class ReadThread
    extends TestThread {
        public ReadThread(int id) {
            super("ReadThread-" + id);
        }

        public void doRun() throws Exception {
            for (int k = 0; k < ReadPerformanceDriver.this.incCountPerThread; ++k) {
                if (k % 1000000 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), k);
                }
                if (ReadPerformanceDriver.this.readonly) {
                    this.readInReadonlyMode();
                    continue;
                }
                this.readInUpdateMode();
            }
        }

        @TransactionalMethod(readonly=true)
        public int readInReadonlyMode() {
            return ReadPerformanceDriver.this.ref.get();
        }

        @TransactionalMethod(readonly=false)
        public int readInUpdateMode() {
            return ReadPerformanceDriver.this.ref.get();
        }
    }
}

