/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.commitbarriers;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.commitbarriers.CountDownCommitBarrier;

public class CountDownCommitBarrier_awaitOpenUninterruptiblyTest {
    private CountDownCommitBarrier barrier;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @After
    public void tearDown() {
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @Test
    public void whenStartInterrupted() {
        this.barrier = new CountDownCommitBarrier(1);
        TestThread t = new TestThread(){

            public void doRun() throws Exception {
                Thread.currentThread().interrupt();
                CountDownCommitBarrier_awaitOpenUninterruptiblyTest.this.barrier.awaitOpenUninterruptibly();
            }
        };
        t.start();
        TestUtils.sleepMs((long)500L);
        TestUtils.assertAlive((Thread[])new Thread[]{t});
        this.barrier.abort();
        TestUtils.joinAll((TestThread[])new TestThread[]{t});
    }

    @Test
    public void whenInterruptedWhileWaiting() {
        this.barrier = new CountDownCommitBarrier(1);
        TestThread t = new TestThread(){

            public void doRun() throws Exception {
                CountDownCommitBarrier_awaitOpenUninterruptiblyTest.this.barrier.awaitOpenUninterruptibly();
            }
        };
        t.start();
        TestUtils.sleepMs((long)500L);
        t.interrupt();
        TestUtils.sleepMs((long)500L);
        TestUtils.assertAlive((Thread[])new Thread[]{t});
        this.barrier.abort();
        TestUtils.joinAll((TestThread[])new TestThread[]{t});
    }

    @Test
    public void whenAbortedWhileWaiting() {
        this.barrier = new CountDownCommitBarrier(1);
        TestThread t = new TestThread(){

            public void doRun() throws Exception {
                CountDownCommitBarrier_awaitOpenUninterruptiblyTest.this.barrier.awaitOpenUninterruptibly();
            }
        };
        t.start();
        TestUtils.sleepMs((long)500L);
        this.barrier.abort();
        TestUtils.joinAll((TestThread[])new TestThread[]{t});
    }

    @Test
    public void whenCommittedWhileWaiting() throws InterruptedException {
        this.barrier = new CountDownCommitBarrier(1);
        TestThread t = new TestThread(){

            public void doRun() throws Exception {
                CountDownCommitBarrier_awaitOpenUninterruptiblyTest.this.barrier.awaitOpenUninterruptibly();
            }
        };
        t.start();
        TestUtils.sleepMs((long)500L);
        this.barrier.countDown();
        TestUtils.joinAll((TestThread[])new TestThread[]{t});
        Assert.assertTrue((boolean)this.barrier.isCommitted());
    }

    @Test
    public void whenCommitted() throws InterruptedException {
        this.barrier = new CountDownCommitBarrier(0);
        this.barrier.awaitOpenUninterruptibly();
        Assert.assertTrue((boolean)this.barrier.isCommitted());
        Assert.assertEquals((long)0L, (long)this.barrier.getNumberWaiting());
    }

    @Test
    public void whenAborted() throws InterruptedException {
        this.barrier = new CountDownCommitBarrier(1);
        this.barrier.abort();
        this.barrier.awaitOpenUninterruptibly();
        Assert.assertTrue((boolean)this.barrier.isAborted());
        Assert.assertEquals((long)0L, (long)this.barrier.getNumberWaiting());
    }
}

