/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.commitbarriers;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.commitbarriers.CountDownCommitBarrier;

public class CountDownCommitBarrier_constructorTest {
    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @After
    public void tearDown() {
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @Test(expected=IllegalArgumentException.class)
    public void whenNegativeParties_thenIllegalArgumentException() {
        new CountDownCommitBarrier(-1);
    }

    @Test
    public void whenZeroParties_thenBarrierCommitted() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(0);
        Assert.assertTrue((boolean)barrier.isCommitted());
        Assert.assertEquals((long)0L, (long)barrier.getParties());
        Assert.assertEquals((long)0L, (long)barrier.getNumberWaiting());
    }

    @Test
    public void whenPositiveParties() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(10);
        Assert.assertTrue((boolean)barrier.isClosed());
        Assert.assertEquals((long)10L, (long)barrier.getParties());
        Assert.assertEquals((long)0L, (long)barrier.getNumberWaiting());
    }
}

