/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.commitbarriers;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.commitbarriers.CommitBarrierOpenException;
import org.multiverse.commitbarriers.CountDownCommitBarrier;
import org.multiverse.commitbarriers.JoinCommitThread;
import org.multiverse.stms.AbstractTransactionImpl;
import org.multiverse.transactional.primitives.TransactionalInteger;

public class CountDownCommitBarrier_joinCommitTest {
    private CountDownCommitBarrier barrier;
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @After
    public void tearDown() {
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @Test
    public void whenNullTransaction() throws InterruptedException {
        this.barrier = new CountDownCommitBarrier(1);
        try {
            this.barrier.joinCommit(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.barrier.isClosed());
        Assert.assertEquals((long)0L, (long)this.barrier.getNumberWaiting());
    }

    @Test
    public void whenLastOneEntering() throws InterruptedException {
        this.barrier = new CountDownCommitBarrier(1);
        Transaction tx = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).build().start();
        this.barrier.joinCommit(tx);
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertTrue((boolean)this.barrier.isCommitted());
        Assert.assertEquals((long)0L, (long)this.barrier.getNumberWaiting());
    }

    @Test
    public void whenAbortedWhileWaiting() throws InterruptedException {
        this.barrier = new CountDownCommitBarrier(2);
        final TransactionalInteger ref = new TransactionalInteger();
        TestThread t = new TestThread(){

            @TransactionalMethod
            public void doRun() throws Exception {
                Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
                ref.set(10);
                CountDownCommitBarrier_joinCommitTest.this.barrier.joinCommit(tx);
            }
        };
        t.setPrintStackTrace(false);
        t.start();
        TestUtils.sleepMs((long)500L);
        TestUtils.assertAlive((Thread[])new Thread[]{t});
        Assert.assertTrue((boolean)this.barrier.isClosed());
        this.barrier.abort();
        t.join();
        t.assertFailedWithException(IllegalStateException.class);
        Assert.assertTrue((boolean)this.barrier.isAborted());
        Assert.assertEquals((long)0L, (long)ref.get());
    }

    @Test
    public void whenCommittedWhileWaiting() {
        this.barrier = new CountDownCommitBarrier(3);
        JoinCommitThread t1 = new JoinCommitThread(this.barrier);
        JoinCommitThread t2 = new JoinCommitThread(this.barrier);
        TestUtils.startAll((TestThread[])new TestThread[]{t1, t2});
        TestUtils.sleepMs((long)500L);
        this.barrier.countDown();
        TestUtils.joinAll((TestThread[])new TestThread[]{t1, t2});
        Assert.assertTrue((boolean)this.barrier.isCommitted());
    }

    @Test
    public void whenInterruptedWhileWaiting() throws InterruptedException {
        this.barrier = new CountDownCommitBarrier(2);
        final TransactionalInteger ref = new TransactionalInteger();
        TestThread t = new TestThread(){

            @TransactionalMethod
            public void doRun() throws Exception {
                Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
                ref.set(10);
                CountDownCommitBarrier_joinCommitTest.this.barrier.joinCommit(tx);
            }
        };
        t.setPrintStackTrace(false);
        t.start();
        TestUtils.sleepMs((long)500L);
        t.interrupt();
        t.join();
        t.assertFailedWithException(InterruptedException.class);
        Assert.assertEquals((long)0L, (long)ref.get());
        Assert.assertTrue((boolean)this.barrier.isAborted());
    }

    @Test
    public void whenTransactionAlreadyCommitted() throws InterruptedException {
        this.barrier = new CountDownCommitBarrier(1);
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        tx.commit();
        try {
            this.barrier.joinCommit((Transaction)tx);
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertTrue((boolean)this.barrier.isClosed());
    }

    @Test
    public void whenTransactionAlreadyAborted_thenDeadTransactionException() throws InterruptedException {
        this.barrier = new CountDownCommitBarrier(1);
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        tx.abort();
        try {
            this.barrier.joinCommit((Transaction)tx);
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertTrue((boolean)this.barrier.isClosed());
    }

    @Test
    public void whenAborted_thenCommitBarrierOpenException() throws InterruptedException {
        this.barrier = new CountDownCommitBarrier(1);
        this.barrier.abort();
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        try {
            this.barrier.joinCommit((Transaction)tx);
            Assert.fail();
        }
        catch (CommitBarrierOpenException commitBarrierOpenException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.barrier.isAborted());
        Assert.assertEquals((long)0L, (long)this.barrier.getNumberWaiting());
    }

    @Test
    public void whenCommitted_thenCommitBarrierOpenException() throws InterruptedException {
        this.barrier = new CountDownCommitBarrier(0);
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        try {
            this.barrier.joinCommit((Transaction)tx);
            Assert.fail();
        }
        catch (CommitBarrierOpenException commitBarrierOpenException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.barrier.isCommitted());
        Assert.assertEquals((long)0L, (long)this.barrier.getNumberWaiting());
    }
}

