/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.commitbarriers;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.commitbarriers.CommitBarrierOpenException;
import org.multiverse.commitbarriers.CountDownCommitBarrier;
import org.multiverse.stms.AbstractTransactionImpl;
import org.multiverse.transactional.primitives.TransactionalInteger;

public class CountDownCommitBarrier_joinCommitUninterruptiblyWithTransactionTest {
    private CountDownCommitBarrier barrier;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @After
    public void tearDown() {
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @Test
    public void whenTransactionNull() {
        this.barrier = new CountDownCommitBarrier(1);
        try {
            this.barrier.joinCommitUninterruptibly(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.barrier.isClosed());
        Assert.assertEquals((long)0L, (long)this.barrier.getNumberWaiting());
    }

    @Test
    @Ignore
    public void whenTransactionFailsToPrepare() {
        this.barrier = new CountDownCommitBarrier(1);
    }

    @Test
    public void whenTransactionAborted_thenDeadTransactionException() {
        this.barrier = new CountDownCommitBarrier(1);
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        tx.abort();
        try {
            this.barrier.joinCommitUninterruptibly((Transaction)tx);
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertTrue((boolean)this.barrier.isClosed());
        Assert.assertEquals((long)0L, (long)this.barrier.getNumberWaiting());
    }

    @Test
    public void whenTransactionCommitted_thenDeadTransactionException() {
        this.barrier = new CountDownCommitBarrier(1);
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        tx.commit();
        try {
            this.barrier.joinCommitUninterruptibly((Transaction)tx);
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertTrue((boolean)this.barrier.isClosed());
        Assert.assertEquals((long)0L, (long)this.barrier.getNumberWaiting());
    }

    @Test
    @Ignore
    public void whenStartingInterrupted() {
    }

    @Test
    public void whenInterruptedWhileWaiting_thenNoInterruption() throws InterruptedException {
        this.barrier = new CountDownCommitBarrier(2);
        final TransactionalInteger ref = new TransactionalInteger();
        TestThread t = new TestThread(){

            @TransactionalMethod
            public void doRun() throws Exception {
                ref.inc();
                Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
                CountDownCommitBarrier_joinCommitUninterruptiblyWithTransactionTest.this.barrier.joinCommitUninterruptibly(tx);
            }
        };
        t.setPrintStackTrace(false);
        t.start();
        TestUtils.sleepMs((long)500L);
        t.interrupt();
        TestUtils.sleepMs((long)500L);
        TestUtils.assertAlive((Thread[])new Thread[]{t});
        Assert.assertTrue((boolean)this.barrier.isClosed());
    }

    @Test
    public void whenCommittedWhileWaiting() throws InterruptedException {
        this.barrier = new CountDownCommitBarrier(2);
        final TransactionalInteger ref = new TransactionalInteger();
        TestThread t = new TestThread(){

            @TransactionalMethod
            public void doRun() throws Exception {
                ref.inc();
                Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
                CountDownCommitBarrier_joinCommitUninterruptiblyWithTransactionTest.this.barrier.joinCommitUninterruptibly(tx);
            }
        };
        t.setPrintStackTrace(false);
        t.start();
        TestUtils.sleepMs((long)500L);
        this.barrier.countDown();
        TestUtils.sleepMs((long)500L);
        t.join();
        t.assertNothingThrown();
        Assert.assertTrue((boolean)this.barrier.isCommitted());
        Assert.assertEquals((long)1L, (long)ref.get());
        Assert.assertEquals((long)0L, (long)this.barrier.getNumberWaiting());
    }

    @Test
    public void whenAbortedWhileWaiting_() throws InterruptedException {
        this.barrier = new CountDownCommitBarrier(2);
        final TransactionalInteger ref = new TransactionalInteger();
        TestThread t = new TestThread(){

            @TransactionalMethod
            public void doRun() throws Exception {
                ref.inc();
                Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
                CountDownCommitBarrier_joinCommitUninterruptiblyWithTransactionTest.this.barrier.joinCommitUninterruptibly(tx);
            }
        };
        t.setPrintStackTrace(false);
        t.start();
        TestUtils.sleepMs((long)500L);
        this.barrier.abort();
        TestUtils.sleepMs((long)500L);
        t.join();
        t.assertFailedWithException(IllegalStateException.class);
        Assert.assertTrue((boolean)this.barrier.isAborted());
        Assert.assertEquals((long)0L, (long)ref.get());
        Assert.assertEquals((long)0L, (long)this.barrier.getNumberWaiting());
    }

    @Test
    public void whenAborted_thenCommitBarrierOpenException() {
        this.barrier = new CountDownCommitBarrier(1);
        this.barrier.abort();
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        try {
            this.barrier.joinCommitUninterruptibly((Transaction)tx);
            Assert.fail();
        }
        catch (CommitBarrierOpenException commitBarrierOpenException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.barrier.isAborted());
        Assert.assertEquals((long)0L, (long)this.barrier.getNumberWaiting());
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenCommitted_thenCommitBarrierOpenException() {
        this.barrier = new CountDownCommitBarrier(0);
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        try {
            this.barrier.joinCommitUninterruptibly((Transaction)tx);
            Assert.fail();
        }
        catch (CommitBarrierOpenException commitBarrierOpenException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.barrier.isCommitted());
        Assert.assertEquals((long)0L, (long)this.barrier.getNumberWaiting());
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
    }
}

