/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.commitbarriers;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.commitbarriers.CommitBarrierOpenException;
import org.multiverse.commitbarriers.CountDownCommitBarrier;

public class CountDownCommitBarrier_setTimeoutTest {
    @Test
    public void whenNullTimeUnit_thenNullPointerException() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(1);
        try {
            barrier.setTimeout(10L, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)barrier.isClosed());
    }

    @Test
    public void whenTimedOut() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(1);
        barrier.setTimeout(500L, TimeUnit.MILLISECONDS);
        TestUtils.sleepMs((long)1000L);
        Assert.assertTrue((boolean)barrier.isAborted());
    }

    @Test
    public void whenCommittedBeforeTimeout() throws InterruptedException {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(1);
        barrier.setTimeout(500L, TimeUnit.MILLISECONDS);
        barrier.countDown();
        TestUtils.sleepMs((long)1000L);
        Assert.assertTrue((boolean)barrier.isCommitted());
    }

    @Test
    public void whenAbortedBeforeTimeout() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(1);
        barrier.setTimeout(500L, TimeUnit.MILLISECONDS);
        barrier.abort();
        TestUtils.sleepMs((long)1000L);
        Assert.assertTrue((boolean)barrier.isAborted());
    }

    @Test
    public void whenCommitted_thenCommitBarrierOpenException() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(0);
        try {
            barrier.setTimeout(10L, TimeUnit.SECONDS);
            Assert.fail();
        }
        catch (CommitBarrierOpenException commitBarrierOpenException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)barrier.isCommitted());
    }

    @Test
    public void whenAborted_thenCommitBarrierOpenException() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(1);
        barrier.abort();
        try {
            barrier.setTimeout(10L, TimeUnit.SECONDS);
            Assert.fail();
        }
        catch (CommitBarrierOpenException commitBarrierOpenException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)barrier.isAborted());
    }
}

