/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.commitbarriers;

import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.commitbarriers.CommitBarrierOpenException;
import org.multiverse.commitbarriers.CountDownCommitBarrier;
import org.multiverse.stms.AbstractTransactionImpl;
import org.multiverse.transactional.primitives.TransactionalInteger;

public class CountDownCommitBarrier_tryJoinCommitWithTimeoutTest {
    private CountDownCommitBarrier barrier;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @After
    public void tearDown() {
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @Test
    public void whenNullTransaction_thenNullPointerException() throws InterruptedException {
        this.barrier = new CountDownCommitBarrier(1);
        try {
            this.barrier.tryJoinCommit(null, 1L, TimeUnit.DAYS);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.barrier.isClosed());
        Assert.assertEquals((long)0L, (long)this.barrier.getNumberWaiting());
    }

    @Test
    public void whenNullTimeout_thenNullPointerException() throws InterruptedException {
        this.barrier = new CountDownCommitBarrier(1);
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        try {
            this.barrier.tryJoinCommit((Transaction)tx, 1L, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertTrue((boolean)this.barrier.isClosed());
        Assert.assertEquals((long)0L, (long)this.barrier.getNumberWaiting());
    }

    @Test
    @Ignore
    public void whenNotLastOne() {
    }

    @Test
    @Ignore
    public void whenInterruptedWhileWaiting() {
    }

    @Test
    @Ignore
    public void whenTimeout() {
    }

    @Test
    @Ignore
    public void whenAbortedWhileWaiting() {
    }

    @Test
    public void whenCommittedWhileWaiting() throws InterruptedException {
        this.barrier = new CountDownCommitBarrier(2);
        final TransactionalInteger ref = new TransactionalInteger();
        TestThread t = new TestThread(){

            @TransactionalMethod
            public void doRun() throws Exception {
                ref.inc();
                Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
                boolean result = CountDownCommitBarrier_tryJoinCommitWithTimeoutTest.this.barrier.tryJoinCommit(tx, 1L, TimeUnit.DAYS);
                Assert.assertTrue((boolean)result);
            }
        };
        t.start();
        TestUtils.sleepMs((long)500L);
        this.barrier.countDown();
        t.join();
        t.assertNothingThrown();
        Assert.assertTrue((boolean)this.barrier.isCommitted());
        Assert.assertEquals((long)1L, (long)ref.get());
    }

    @Test
    public void whenAborted_thenCommitBarrierOpenException() throws InterruptedException {
        this.barrier = new CountDownCommitBarrier(1);
        this.barrier.abort();
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        try {
            this.barrier.tryJoinCommit((Transaction)tx, 1L, TimeUnit.DAYS);
            Assert.fail();
        }
        catch (CommitBarrierOpenException commitBarrierOpenException) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertTrue((boolean)this.barrier.isAborted());
        Assert.assertEquals((long)0L, (long)this.barrier.getNumberWaiting());
    }

    @Test
    public void whenCommitted_thenCommitBarrierOpenException() throws InterruptedException {
        this.barrier = new CountDownCommitBarrier(0);
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        try {
            this.barrier.tryJoinCommit((Transaction)tx, 1L, TimeUnit.DAYS);
            Assert.fail();
        }
        catch (CommitBarrierOpenException commitBarrierOpenException) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertTrue((boolean)this.barrier.isCommitted());
        Assert.assertEquals((long)0L, (long)this.barrier.getNumberWaiting());
    }
}

