/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.commitbarriers;

import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.commitbarriers.VetoCommitBarrier;

public class VetoCommitBarrier_tryAwaitOpenUninterruptiblyTest {
    private VetoCommitBarrier barrier;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @After
    public void tearDown() {
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @Test
    public void whenNullTimeout_thenNullPointerException() {
        this.barrier = new VetoCommitBarrier();
        try {
            this.barrier.tryAwaitOpenUninterruptibly(1L, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.barrier.isClosed());
    }

    @Test
    public void whenInterruptedWhileWaiting() throws InterruptedException {
        this.barrier = new VetoCommitBarrier();
        TestThread t = new TestThread(){

            public void doRun() {
                boolean result = VetoCommitBarrier_tryAwaitOpenUninterruptiblyTest.this.barrier.tryAwaitOpenUninterruptibly(1500L, TimeUnit.MILLISECONDS);
                Assert.assertFalse((boolean)result);
            }
        };
        t.start();
        TestUtils.sleepMs((long)500L);
        TestUtils.assertAlive((Thread[])new Thread[]{t});
        t.interrupt();
        t.join();
        t.assertNothingThrown();
        Assert.assertTrue((boolean)t.hasEndedWithInterruptStatus());
        Assert.assertTrue((boolean)this.barrier.isClosed());
    }

    @Test
    public void whenCommittedWhileWaiting() throws InterruptedException {
        this.barrier = new VetoCommitBarrier();
        TestThread t = new TestThread(){

            public void doRun() throws Exception {
                boolean result = VetoCommitBarrier_tryAwaitOpenUninterruptiblyTest.this.barrier.tryAwaitOpenUninterruptibly(1L, TimeUnit.DAYS);
                Assert.assertTrue((boolean)result);
            }
        };
        t.start();
        TestUtils.sleepMs((long)500L);
        TestUtils.assertAlive((Thread[])new Thread[]{t});
        this.barrier.vetoCommit();
        t.join();
        t.assertNothingThrown();
        Assert.assertTrue((boolean)this.barrier.isCommitted());
    }

    @Test
    public void whenAbortedWhileWaiting() throws InterruptedException {
        this.barrier = new VetoCommitBarrier();
        TestThread t = new TestThread(){

            public void doRun() throws Exception {
                boolean result = VetoCommitBarrier_tryAwaitOpenUninterruptiblyTest.this.barrier.tryAwaitOpenUninterruptibly(1L, TimeUnit.DAYS);
                Assert.assertTrue((boolean)result);
            }
        };
        t.start();
        TestUtils.sleepMs((long)500L);
        TestUtils.assertAlive((Thread[])new Thread[]{t});
        this.barrier.abort();
        t.join();
        t.assertNothingThrown();
        Assert.assertTrue((boolean)this.barrier.isAborted());
    }

    @Test
    public void whenTimeout() throws InterruptedException {
        this.barrier = new VetoCommitBarrier();
        TestThread t = new TestThread(){

            public void doRun() throws Exception {
                boolean result = VetoCommitBarrier_tryAwaitOpenUninterruptiblyTest.this.barrier.tryAwaitOpenUninterruptibly(1L, TimeUnit.SECONDS);
                Assert.assertFalse((boolean)result);
            }
        };
        t.start();
        t.join();
        t.assertNothingThrown();
    }

    @Test
    public void whenCommitted() {
        this.barrier = new VetoCommitBarrier();
        this.barrier.vetoCommit();
        boolean result = this.barrier.tryAwaitOpenUninterruptibly(1L, TimeUnit.DAYS);
        Assert.assertTrue((boolean)result);
        Assert.assertTrue((boolean)this.barrier.isCommitted());
    }

    @Test
    public void whenAborted() {
        this.barrier = new VetoCommitBarrier();
        this.barrier.abort();
        boolean result = this.barrier.tryAwaitOpenUninterruptibly(1L, TimeUnit.DAYS);
        Assert.assertTrue((boolean)result);
        Assert.assertTrue((boolean)this.barrier.isAborted());
    }
}

