/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.templates.TransactionTemplate;
import org.multiverse.transactional.primitives.TransactionalInteger;

public class NestedTransactionTest {
    private TransactionalInteger ref;
    private int maximumDepth = 50;
    private Stm stm;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        this.ref = new TransactionalInteger();
    }

    @Test
    public void testTransactionalMethod() {
        long version = this.stm.getVersion();
        this.beginTxMethod();
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)1L, (long)this.ref.get());
    }

    @TransactionalMethod
    public void beginTxMethod() {
        Transaction t = ThreadLocalTransaction.getThreadLocalTransaction();
        this.recursiveTxMethod(0, t);
    }

    @TransactionalMethod
    public void recursiveTxMethod(int currentDepth, Transaction expectedTransaction) {
        Transaction found = ThreadLocalTransaction.getThreadLocalTransaction();
        Assert.assertSame((Object)expectedTransaction, (Object)found);
        if (currentDepth == this.maximumDepth) {
            this.ref.inc();
        } else {
            this.recursiveTxMethod(currentDepth + 1, found);
        }
    }

    @Test
    public void testTransactionTemplate() {
        long version = this.stm.getVersion();
        this.beginTxTemplate();
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)1L, (long)this.ref.get());
    }

    public void beginTxTemplate() {
        TransactionFactory txFactory = this.stm.getTransactionFactoryBuilder().setReadonly(false).build();
        new TransactionTemplate(txFactory){

            public Object execute(Transaction t) throws Exception {
                NestedTransactionTest.this.recursiveTxTemplate(0, t);
                return null;
            }
        }.execute();
    }

    public void recursiveTxTemplate(final int currentDepth, final Transaction expectedTransaction) {
        TransactionFactory txFactory = this.stm.getTransactionFactoryBuilder().build();
        new TransactionTemplate(txFactory){

            public Object execute(Transaction t) throws Exception {
                Transaction found = ThreadLocalTransaction.getThreadLocalTransaction();
                Assert.assertSame((Object)expectedTransaction, (Object)found);
                if (currentDepth == NestedTransactionTest.this.maximumDepth) {
                    NestedTransactionTest.this.ref.inc();
                } else {
                    NestedTransactionTest.this.recursiveTxTemplate(currentDepth + 1, found);
                }
                return null;
            }
        }.execute();
    }
}

