/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.ThreadLocalTransaction;

public class ToStringEqualsAndHashNotUsedTest {
    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test_1() {
        this.test(1);
    }

    @Test
    public void test_10() {
        this.test(10);
    }

    @Test
    public void test_100() {
        this.test(100);
    }

    @Test
    public void test_1000() {
        this.test(1000);
    }

    @Test
    public void test_10000() {
        this.test(10000);
    }

    @Test
    public void test_1000000() {
        this.test(100000);
    }

    @Test
    public void test_10000000() {
        this.test(1000000);
    }

    public void test(int count) {
        Ref[] refs = new Ref[count];
        for (int k = 0; k < count; ++k) {
            refs[k] = new Ref(0);
        }
        this.inc(refs);
    }

    @TransactionalMethod
    private void inc(Ref[] refs) {
        for (Ref ref : refs) {
            ref.set(ref.get() + 10);
        }
    }

    @TransactionalObject
    class Ref {
        private int value;

        public Ref(int value) {
            this.value = value;
        }

        public int get() {
            return this.value;
        }

        public void set(int value) {
            this.value = value;
        }

        public String toString() {
            Assert.fail();
            return null;
        }

        public boolean equals(Object item) {
            Assert.fail();
            return false;
        }

        public int hashCode() {
            Assert.fail();
            return 0;
        }
    }
}

