/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.classicproblems;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.StmUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.transactional.primitives.TransactionalInteger;

public class DiningPhilosophersStressTest {
    private int philosopherCount = 10;
    private int eatCount = 1000;
    private TransactionalInteger[] forks;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test() {
        this.createForks();
        TestThread[] philosopherThreads = this.createPhilosopherThreads();
        TestUtils.startAll((TestThread[])philosopherThreads);
        TestUtils.joinAll((TestThread[])philosopherThreads);
        this.assertAllForksHaveReturned();
    }

    public void assertAllForksHaveReturned() {
        for (TransactionalInteger fork : this.forks) {
            Assert.assertEquals((long)0L, (long)fork.get());
        }
    }

    public PhilosopherThread[] createPhilosopherThreads() {
        PhilosopherThread[] threads = new PhilosopherThread[this.philosopherCount];
        for (int k = 0; k < this.philosopherCount; ++k) {
            TransactionalInteger leftFork = this.forks[k];
            TransactionalInteger rightFork = k == this.philosopherCount - 1 ? this.forks[0] : this.forks[k + 1];
            threads[k] = new PhilosopherThread(k, leftFork, rightFork);
        }
        return threads;
    }

    public void createForks() {
        this.forks = new TransactionalInteger[this.philosopherCount];
        for (int k = 0; k < this.forks.length; ++k) {
            this.forks[k] = new TransactionalInteger(0);
        }
    }

    class PhilosopherThread
    extends TestThread {
        private final TransactionalInteger leftFork;
        private final TransactionalInteger rightFork;

        PhilosopherThread(int id, TransactionalInteger leftFork, TransactionalInteger rightFork) {
            super("PhilosopherThread-" + id);
            this.leftFork = leftFork;
            this.rightFork = rightFork;
        }

        public void doRun() {
            for (int k = 0; k < DiningPhilosophersStressTest.this.eatCount; ++k) {
                if (k % 100 == 0) {
                    System.out.printf("%s at %s\n", this.getName(), k);
                }
                this.eat();
            }
        }

        public void eat() {
            this.takeForks();
            this.stuffHole();
            this.releaseForks();
        }

        private void stuffHole() {
            TestUtils.sleepRandomMs((int)50);
        }

        @TransactionalMethod
        public void releaseForks() {
            this.leftFork.dec();
            this.rightFork.dec();
        }

        @TransactionalMethod(maxRetries=10000)
        public void takeForks() {
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            if (this.leftFork.get() == 1) {
                StmUtils.retry();
            } else {
                this.leftFork.inc();
            }
            if (this.rightFork.get() == 1) {
                StmUtils.retry();
            } else {
                this.rightFork.inc();
            }
        }
    }
}

