/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.financial;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.ThreadLocalTransaction;

public class MoneyTransferStressTest {
    private final int threadCount = 20;
    private final int accountCount = 10;
    private final int transferCount = 1000;
    private long initialAmount;
    private BankAccount[] bankAccounts;
    private TransferThread[] threads;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.bankAccounts = new BankAccount[10];
        for (int k = 0; k < 10; ++k) {
            long amount = TestUtils.randomInt((int)1000);
            this.initialAmount += amount;
            this.bankAccounts[k] = new BankAccount(amount);
        }
        this.threads = this.createThreads();
    }

    @Test
    public void test() {
        TestUtils.startAll((TestThread[])this.threads);
        TestUtils.joinAll((TestThread[])this.threads);
        Assert.assertEquals((long)this.initialAmount, (long)this.getTotal());
    }

    private long getTotal() {
        long sum = 0L;
        for (BankAccount account : this.bankAccounts) {
            sum += account.getBalance();
        }
        return sum;
    }

    private TransferThread[] createThreads() {
        TransferThread[] threads = new TransferThread[20];
        for (int k = 0; k < threads.length; ++k) {
            threads[k] = new TransferThread(k);
        }
        return threads;
    }

    private static class NotEnoughMoneyException
    extends RuntimeException {
        private NotEnoughMoneyException() {
        }
    }

    @TransactionalObject
    private static class BankAccount {
        private long balance;

        private BankAccount(long balance) {
            this.balance = balance;
        }

        @TransactionalMethod(readonly=true)
        public long getBalance() {
            return this.balance;
        }

        public void setBalance(long balance) {
            if (balance < 0L) {
                throw new NotEnoughMoneyException();
            }
            this.balance = balance;
        }

        public void inc(long delta) {
            this.setBalance(this.getBalance() + delta);
        }

        public void dec(long delta) {
            this.setBalance(this.getBalance() - delta);
        }
    }

    private class TransferThread
    extends TestThread {
        public TransferThread(int id) {
            super("TransferThread-" + id);
        }

        public void doRun() throws Exception {
            int k = 0;
            do {
                try {
                    this.transferBetweenRandomAccounts();
                    if (k % 100 == 0) {
                        System.out.printf("Thread %s is at iteration %s\n", this.getName(), k);
                    }
                    ++k;
                }
                catch (NotEnoughMoneyException notEnoughMoneyException) {
                    // empty catch block
                }
            } while (k < 1000);
        }

        @TransactionalMethod
        private void transferBetweenRandomAccounts() {
            BankAccount from = MoneyTransferStressTest.this.bankAccounts[TestUtils.randomInt((int)(MoneyTransferStressTest.this.bankAccounts.length - 1))];
            BankAccount to = MoneyTransferStressTest.this.bankAccounts[TestUtils.randomInt((int)(MoneyTransferStressTest.this.bankAccounts.length - 1))];
            int amount = TestUtils.randomInt((int)1000);
            to.inc(amount);
            TestUtils.sleepRandomMs((int)20);
            from.dec(amount);
        }
    }
}

